/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.consistency;

import com.swirlds.demo.consistency.ConsistencyTestingToolRound;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransactionHandlingHistory
implements Closeable {
    private static final Logger logger = LogManager.getLogger(TransactionHandlingHistory.class);
    private final Map<Long, ConsistencyTestingToolRound> roundHistory = new HashMap<Long, ConsistencyTestingToolRound>();
    private final Set<Long> seenTransactions = new HashSet<Long>();
    private Path logFilePath;
    private BufferedWriter writer;
    private long previousRoundHandled;

    public void init(@NonNull Path logFilePath) {
        this.logFilePath = Objects.requireNonNull(logFilePath);
        logger.info(LogMarker.STARTUP.getMarker(), "Consistency testing tool log path: {}", (Object)logFilePath);
        this.tryReadLog();
        try {
            this.writer = new BufferedWriter(new FileWriter(logFilePath.toFile(), true));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open writer for transaction handling history", e);
        }
    }

    private void tryReadLog() {
        if (!Files.exists(this.logFilePath, new LinkOption[0])) {
            logger.info(LogMarker.STARTUP.getMarker(), "No log file found. Starting without any previous history");
            return;
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Log file found. Parsing previous history");
        try (FileReader in = new FileReader(this.logFilePath.toFile());
             BufferedReader reader = new BufferedReader(in);){
            reader.lines().forEach(line -> {
                ConsistencyTestingToolRound parsedRound = ConsistencyTestingToolRound.fromString(line);
                if (parsedRound == null) {
                    logger.warn(LogMarker.STARTUP.getMarker(), "Failed to parse line from log file: {}", line);
                    return;
                }
                this.addRoundToHistory(parsedRound);
            });
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to read log file", (Throwable)e);
        }
    }

    @Nullable
    private String addTransaction(long transaction) {
        if (!this.seenTransactions.add(transaction)) {
            String error = "Transaction with contents `" + transaction + "` has already been applied to the state";
            logger.error(LogMarker.EXCEPTION.getMarker(), error);
            return error;
        }
        return null;
    }

    @Nullable
    private String compareWithHistoricalRound(@NonNull ConsistencyTestingToolRound newRound, @NonNull ConsistencyTestingToolRound historicalRound) {
        Objects.requireNonNull(newRound);
        Objects.requireNonNull(historicalRound);
        if (!newRound.equals(historicalRound)) {
            String error = "Round " + newRound.roundNumber() + " with transactions " + String.valueOf(newRound.transactionsContents()) + " doesn't match historical counterpart with transactions " + String.valueOf(historicalRound.transactionsContents());
            logger.error(LogMarker.EXCEPTION.getMarker(), error);
            return error;
        }
        return null;
    }

    @NonNull
    private List<String> addRoundToHistory(@NonNull ConsistencyTestingToolRound newRound) {
        ArrayList<String> errors = new ArrayList<String>();
        this.roundHistory.put(newRound.roundNumber(), newRound);
        newRound.transactionsContents().forEach(transaction -> {
            String error = this.addTransaction((long)transaction);
            if (error != null) {
                errors.add(error);
            }
        });
        if (this.roundHistory.size() <= 1) {
            this.previousRoundHandled = newRound.roundNumber();
            return errors;
        }
        long newRoundNumber = newRound.roundNumber();
        if (newRoundNumber <= this.previousRoundHandled) {
            String error = "Round " + newRoundNumber + " is not greater than round " + this.previousRoundHandled;
            logger.error(LogMarker.EXCEPTION.getMarker(), error);
            errors.add(error);
        }
        this.previousRoundHandled = newRound.roundNumber();
        return errors;
    }

    private void writeRoundToLog(@NonNull ConsistencyTestingToolRound round) {
        Objects.requireNonNull(round);
        try {
            this.writer.write(round.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write round `%s` to log".formatted(round.roundNumber()), e);
        }
    }

    @NonNull
    public List<String> processRound(@NonNull ConsistencyTestingToolRound round) {
        Objects.requireNonNull(round);
        ConsistencyTestingToolRound historicalRound = this.roundHistory.get(round.roundNumber());
        ArrayList<String> errors = new ArrayList<String>();
        if (historicalRound == null) {
            errors.addAll(this.addRoundToHistory(round));
            this.writeRoundToLog(round);
        } else {
            String error = this.compareWithHistoricalRound(round, historicalRound);
            if (error != null) {
                errors.add(error);
            }
        }
        return errors;
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close writer for transaction handling history", e);
        }
    }
}

