/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.state.PlatformStateAccessor;
import com.swirlds.platform.state.service.PlatformStateValueAccumulator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.hiero.base.crypto.Hash;
import org.hiero.base.utility.CommonUtils;

public final class PbjConverter {
    @NonNull
    public static PlatformState toPbjPlatformState(@NonNull PlatformStateAccessor accessor) {
        Objects.requireNonNull(accessor);
        return new PlatformState(accessor.getCreationSoftwareVersion(), accessor.getRoundsNonAncient(), accessor.getSnapshot(), CommonUtils.toPbjTimestamp((Instant)accessor.getFreezeTime()), CommonUtils.toPbjTimestamp((Instant)accessor.getLastFrozenTime()), accessor.getLatestFreezeRound(), (Bytes)Optional.ofNullable(accessor.getLegacyRunningEventHash()).map(Hash::getBytes).orElse(null));
    }

    @NonNull
    public static PlatformState toPbjPlatformState(@NonNull PlatformState previousState, @NonNull PlatformStateValueAccumulator accumulator) {
        Objects.requireNonNull(accumulator);
        PlatformState.Builder builder = previousState.copyBuilder();
        if (accumulator.isCreationSoftwareVersionUpdated()) {
            builder.creationSoftwareVersion(accumulator.getCreationSoftwareVersion());
        }
        if (accumulator.isRoundsNonAncientUpdated()) {
            builder.roundsNonAncient(accumulator.getRoundsNonAncient());
        }
        ConsensusSnapshot.Builder consensusSnapshotBuilder = accumulator.isSnapshotUpdated() ? accumulator.getSnapshot().copyBuilder() : previousState.consensusSnapshotOrElse(ConsensusSnapshot.DEFAULT).copyBuilder();
        if (accumulator.isRoundUpdated()) {
            consensusSnapshotBuilder.round(accumulator.getRound());
        }
        if (accumulator.isConsensusTimestampUpdated()) {
            consensusSnapshotBuilder.consensusTimestamp(CommonUtils.toPbjTimestamp((Instant)accumulator.getConsensusTimestamp()));
        }
        builder.consensusSnapshot(consensusSnapshotBuilder);
        if (accumulator.isFreezeTimeUpdated()) {
            builder.freezeTime(CommonUtils.toPbjTimestamp((Instant)accumulator.getFreezeTime()));
        }
        if (accumulator.isLastFrozenTimeUpdated()) {
            builder.lastFrozenTime(CommonUtils.toPbjTimestamp((Instant)accumulator.getLastFrozenTime()));
        }
        if (accumulator.isLatestFreezeRoundUpdated()) {
            builder.latestFreezeRound(accumulator.getLatestFreezeRound());
        }
        if (accumulator.isLegacyRunningEventHashUpdated()) {
            if (accumulator.getLegacyRunningEventHash() == null) {
                builder.legacyRunningEventHash(Bytes.EMPTY);
            } else {
                builder.legacyRunningEventHash(accumulator.getLegacyRunningEventHash().getBytes());
            }
        }
        return builder.build();
    }

    private PbjConverter() {
    }
}

