/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform.nft;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.utility.StopWatch;
import com.swirlds.demo.platform.nft.Nft;
import com.swirlds.demo.platform.nft.NftId;
import com.swirlds.demo.platform.nft.NftLedgerStatistics;
import com.swirlds.fchashmap.FCOneToManyRelation;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkle.test.fixtures.map.pta.MapKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NftLedger
extends PartialBinaryMerkleInternal
implements MerkleInternal {
    private static final Logger logger = LogManager.getLogger(NftLedger.class);
    public static final long CLASS_ID = -626531818109765603L;
    private final FCOneToManyRelation<MapKey, NftId> nftAccounts;

    public NftLedger() {
        this.nftAccounts = new FCOneToManyRelation();
        this.setTokenIdToToken((MerkleMap<NftId, Nft>)new MerkleMap());
    }

    private NftLedger(NftLedger nftLedger) {
        super((PartialBinaryMerkleInternal)nftLedger);
        this.nftAccounts = nftLedger.nftAccounts.copy();
        this.setTokenIdToToken((MerkleMap<NftId, Nft>)nftLedger.getTokenIdToToken().copy());
        nftLedger.setImmutable(true);
    }

    public long getClassId() {
        return -626531818109765603L;
    }

    public int getVersion() {
        return 1;
    }

    public NftLedger copy() {
        return new NftLedger(this);
    }

    public boolean childHasExpectedType(int index, long childClassId) {
        if (index == 0) {
            return childClassId == -7776220400278906634L;
        }
        return true;
    }

    private void setTokenIdToToken(MerkleMap<NftId, Nft> tokenIdToToken) {
        this.setChild(0, (MerkleNode)tokenIdToToken);
    }

    public MerkleMap<NftId, Nft> getTokenIdToToken() {
        return (MerkleMap)this.getChild(0);
    }

    public void rebuild() {
        MerkleMap<NftId, Nft> tokenIdToNft = this.getTokenIdToToken();
        for (Map.Entry entry : tokenIdToNft.entrySet()) {
            this.nftAccounts.associate((Object)((Nft)((Object)entry.getValue())).getMapKey(), (Object)((NftId)entry.getKey()));
        }
    }

    public synchronized void destroyNode() {
        if (!this.nftAccounts.isDestroyed()) {
            this.nftAccounts.release();
        }
    }

    public void mintToken(MapKey key, NftId nftId, Nft token) {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        StopWatch watch = new StopWatch();
        watch.start();
        this.nftAccounts.associate((Object)key, (Object)nftId);
        this.getTokenIdToToken().put((Object)nftId, (MerkleNode)token);
        watch.stop();
        NftLedgerStatistics.recordMintTokenDuration(watch.getTime(TimeUnit.MICROSECONDS));
        NftLedgerStatistics.addMintTokenOperation();
    }

    public void burnToken(NftId nftId) {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        StopWatch watch = new StopWatch();
        watch.start();
        Nft nft = (Nft)this.getTokenIdToToken().remove((Object)nftId);
        if (nft == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to burn token with id {} due to null nft", (Object)nftId);
            return;
        }
        this.nftAccounts.disassociate((Object)nft.getMapKey(), (Object)nftId);
        watch.stop();
        NftLedgerStatistics.recordBurnTokenDuration(watch.getTime(TimeUnit.MICROSECONDS));
        NftLedgerStatistics.addBurnTokenOperation();
    }

    public void transferToken(NftId nftId, MapKey toKey) {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        StopWatch watch = new StopWatch();
        watch.start();
        Nft nft = (Nft)this.getTokenIdToToken().getForModify((Object)nftId);
        if (nft == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to transfer token with id {} due to null nft", (Object)nftId);
            return;
        }
        boolean wasAssociated = this.nftAccounts.disassociate((Object)nft.getMapKey(), (Object)nftId);
        if (!wasAssociated) {
            return;
        }
        nft.setMapKey(toKey);
        this.nftAccounts.associate((Object)toKey.copy(), (Object)nftId);
        this.getTokenIdToToken().replace((Object)nftId, (MerkleNode)nft);
        watch.stop();
        NftLedgerStatistics.recordTransferTokenDuration(watch.getTime(TimeUnit.MICROSECONDS));
        NftLedgerStatistics.addTransferTokenOperation();
    }

    public FCOneToManyRelation<MapKey, NftId> getNftAccounts() {
        return this.nftAccounts;
    }

    public int numberOfTokensByAccount(MapKey key) {
        return this.nftAccounts.getCount((Object)key);
    }

    public List<NftId> getTokensByAccount(MapKey key, int startIndex, int endIndex) {
        return this.nftAccounts.getList((Object)key, startIndex, endIndex);
    }

    private static class ClassVersion {
        private static final int VERSION_ORIGINAL = 1;

        private ClassVersion() {
        }
    }

    private static class ChildIndices {
        public static final int NFT_ID_TO_NFT = 0;
        public static final int CHILD_COUNT = 1;

        private ChildIndices() {
        }
    }
}

