/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.event.source;

import com.swirlds.common.test.fixtures.TransactionGenerator;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.test.fixtures.event.source.AbstractEventSource;
import java.util.LinkedList;
import java.util.Random;

public class StandardEventSource
extends AbstractEventSource {
    private LinkedList<EventImpl> latestEvents = new LinkedList();

    public StandardEventSource(boolean useFakeHashes) {
        this(useFakeHashes, DEFAULT_TRANSACTION_GENERATOR);
    }

    public StandardEventSource(boolean useFakeHashes, TransactionGenerator transactionGenerator) {
        super(useFakeHashes, transactionGenerator);
    }

    public StandardEventSource() {
        this(true);
    }

    private StandardEventSource(StandardEventSource that) {
        super(that);
    }

    @Override
    public StandardEventSource copy() {
        return new StandardEventSource(this);
    }

    @Override
    public void reset() {
        super.reset();
        this.latestEvents = new LinkedList();
    }

    @Override
    public EventImpl getRecentEvent(Random random, int index) {
        if (this.latestEvents.size() == 0) {
            return null;
        }
        if (index >= this.latestEvents.size()) {
            return this.latestEvents.getLast();
        }
        return this.latestEvents.get(index);
    }

    @Override
    public void setLatestEvent(Random random, EventImpl event) {
        this.latestEvents.addFirst(event);
        this.pruneEventList(this.latestEvents);
    }
}

