/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.iss.internal;

import com.swirlds.common.utility.Threshold;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.metrics.IssMetrics;
import com.swirlds.platform.state.iss.internal.ConsensusHashFinder;
import com.swirlds.platform.state.iss.internal.ConsensusHashStatus;
import com.swirlds.platform.state.iss.internal.HashValidityStatus;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;

public class RoundHashValidator {
    private static final Logger logger = LogManager.getLogger(RoundHashValidator.class);
    private final long round;
    private final ConsensusHashFinder hashFinder;
    private Hash selfStateHash;
    private HashValidityStatus status = HashValidityStatus.UNDECIDED;

    public RoundHashValidator(long round, long roundWeight, @NonNull IssMetrics issMetrics) {
        this.round = round;
        this.hashFinder = new ConsensusHashFinder(round, roundWeight, Objects.requireNonNull(issMetrics));
    }

    public long getRound() {
        return this.round;
    }

    public Hash getSelfStateHash() {
        return this.selfStateHash;
    }

    public Hash getConsensusHash() {
        if (this.hashFinder.getStatus() == ConsensusHashStatus.DECIDED) {
            return this.hashFinder.getConsensusHash();
        }
        return null;
    }

    public ConsensusHashFinder getHashFinder() {
        return this.hashFinder;
    }

    public boolean reportSelfHash(@NonNull Hash selfStateHash) {
        if (this.selfStateHash != null) {
            throw new IllegalStateException("self hash reported more than once");
        }
        this.selfStateHash = Objects.requireNonNull(selfStateHash, "selfStateHash must not be null");
        return this.decide();
    }

    public boolean reportHashFromNetwork(@NonNull NodeId nodeId, long nodeWeight, @NonNull Hash stateHash) {
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        Objects.requireNonNull(stateHash, "stateHash must not be null");
        this.hashFinder.addHash(nodeId, nodeWeight, stateHash);
        return this.decide();
    }

    private boolean decide() {
        if (this.status != HashValidityStatus.UNDECIDED) {
            return false;
        }
        if (this.hashFinder.getStatus() == ConsensusHashStatus.CATASTROPHIC_ISS) {
            this.status = HashValidityStatus.CATASTROPHIC_ISS;
            return true;
        }
        if (this.hashFinder.getStatus() == ConsensusHashStatus.DECIDED && this.selfStateHash != null) {
            this.status = this.hashFinder.getConsensusHash().equals((Object)this.selfStateHash) ? HashValidityStatus.VALID : HashValidityStatus.SELF_ISS;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean outOfTime() {
        if (this.status != HashValidityStatus.UNDECIDED) {
            return false;
        }
        if (this.hashFinder.getStatus() == ConsensusHashStatus.DECIDED) {
            if (this.selfStateHash != null) throw new IllegalStateException("The hash finder is decided and the self hash is known, a conclusion about this node's hash validity should have already been reached");
            logger.warn(LogMarker.EXCEPTION.getMarker(), "self state hash for round {} was never reported", (Object)this.round);
            this.status = HashValidityStatus.LACK_OF_DATA;
            return true;
        } else {
            if (this.hashFinder.getStatus() != ConsensusHashStatus.UNDECIDED) throw new IllegalStateException("The hash finder should have been reported as decided already, status = " + String.valueOf((Object)this.hashFinder.getStatus()));
            this.status = Threshold.SUPER_MAJORITY.isSatisfiedBy(this.hashFinder.getHashReportedWeight(), this.hashFinder.getTotalWeight()) ? HashValidityStatus.CATASTROPHIC_LACK_OF_DATA : HashValidityStatus.LACK_OF_DATA;
        }
        return true;
    }

    public HashValidityStatus getStatus() {
        return this.status;
    }

    public boolean hasDisagreement() {
        return this.hashFinder.hasDisagreement();
    }
}

