/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.logging.file;

import com.swirlds.config.api.Configuration;
import com.swirlds.logging.api.Level;
import com.swirlds.logging.api.extensions.event.LogEvent;
import com.swirlds.logging.api.extensions.handler.AbstractLogHandler;
import com.swirlds.logging.api.internal.format.FormattedLinePrinter;
import com.swirlds.logging.io.OutputStreamFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class FileHandler
extends AbstractLogHandler {
    private static final int EVENT_LOG_PRINTER_SIZE = 4096;
    private final OutputStream outputStream;
    private final FormattedLinePrinter format;

    public FileHandler(@NonNull String handlerName, @NonNull Configuration configuration, boolean buffered) throws IOException {
        super(handlerName, configuration);
        this.format = FormattedLinePrinter.createForHandler(handlerName, configuration);
        try {
            this.outputStream = buffered ? OutputStreamFactory.getInstance().bufferedOutputStream(configuration, handlerName) : OutputStreamFactory.getInstance().outputStream(configuration, handlerName);
        }
        catch (IOException e) {
            throw new IOException("Could not create FileHandler", e);
        }
    }

    @Override
    public void handle(@NonNull LogEvent event) {
        StringBuilder writer = new StringBuilder(4096);
        this.format.print(writer, event);
        try {
            this.outputStream.write(writer.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to write to file output stream", exception);
            EMERGENCY_LOGGER.log(event);
        }
    }

    @Override
    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            EMERGENCY_LOGGER.log(Level.WARN, "Failed to flush to file output stream " + this.getName(), e);
        }
    }

    @Override
    public void stopAndFinalize() {
        super.stopAndFinalize();
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            EMERGENCY_LOGGER.log(Level.ERROR, "Failed to close file output stream", exception);
        }
    }
}

