/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.swirlds.base.units.TimeUnit;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;

public class ReconnectMetrics {
    public static final String RECONNECT_CATEGORY = "Reconnect";
    private static final Counter.Config SENDER_START_TIMES_CONFIG = new Counter.Config("Reconnect", "startsReconnectAsSender").withDescription("number of times a node starts reconnect as a sender");
    private final Counter senderStartTimes;
    private static final Counter.Config RECEIVER_START_TIMES_CONFIG = new Counter.Config("Reconnect", "startsReconnectAsReceiver").withDescription("number of times a node starts reconnect as a receiver");
    private final Counter receiverStartTimes;
    private static final Counter.Config SENDER_END_TIMES_CONFIG = new Counter.Config("Reconnect", "endsReconnectAsSender").withDescription("number of times a node ends reconnect as a sender");
    private final Counter senderEndTimes;
    private static final Counter.Config RECEIVER_END_TIMES_CONFIG = new Counter.Config("Reconnect", "endsReconnectAsReceiver").withDescription("number of times a node ends reconnect as a receiver");
    private final Counter receiverEndTimes;
    private static final LongAccumulator.Config SENDER_DURATION_CONFIG = new LongAccumulator.Config("Reconnect", "senderReconnectDurationSeconds").withInitialValue(0L).withAccumulator(Long::sum).withDescription("duration of reconnect as a sender").withUnit(TimeUnit.UNIT_SECONDS.getAbbreviation());
    private final LongAccumulator senderReconnectDurationSeconds;
    private static final LongAccumulator.Config RECEIVER_DURATION_CONFIG = new LongAccumulator.Config("Reconnect", "receiverReconnectDurationSeconds").withInitialValue(0L).withAccumulator(Long::sum).withDescription("duration of reconnect as a receiver").withUnit(TimeUnit.UNIT_SECONDS.getAbbreviation());
    private final LongAccumulator receiverReconnectDurationSeconds;
    private final Metrics metrics;
    private long senderStartNanos = 0L;
    private long receiverStartNanos = 0L;

    public ReconnectMetrics(@NonNull Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics");
        this.senderStartTimes = (Counter)metrics.getOrCreate((MetricConfig)SENDER_START_TIMES_CONFIG);
        this.receiverStartTimes = (Counter)metrics.getOrCreate((MetricConfig)RECEIVER_START_TIMES_CONFIG);
        this.senderEndTimes = (Counter)metrics.getOrCreate((MetricConfig)SENDER_END_TIMES_CONFIG);
        this.receiverEndTimes = (Counter)metrics.getOrCreate((MetricConfig)RECEIVER_END_TIMES_CONFIG);
        this.senderReconnectDurationSeconds = (LongAccumulator)metrics.getOrCreate((MetricConfig)SENDER_DURATION_CONFIG);
        this.receiverReconnectDurationSeconds = (LongAccumulator)metrics.getOrCreate((MetricConfig)RECEIVER_DURATION_CONFIG);
        this.metrics = metrics;
    }

    public void incrementSenderStartTimes() {
        this.senderStartNanos = System.nanoTime();
        this.senderStartTimes.increment();
    }

    public void incrementReceiverStartTimes() {
        this.receiverStartNanos = System.nanoTime();
        this.receiverStartTimes.increment();
    }

    public void incrementSenderEndTimes() {
        this.senderEndTimes.increment();
        this.senderReconnectDurationSeconds.update(Duration.ofNanos(System.nanoTime() - this.senderStartNanos).toSeconds());
    }

    public void incrementReceiverEndTimes() {
        this.receiverEndTimes.increment();
        this.receiverReconnectDurationSeconds.update(Duration.ofNanos(System.nanoTime() - this.receiverStartNanos).toSeconds());
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

