/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.primitive;

import java.util.EmptyStackException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.primitive.IntStack;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public abstract class AbstractIntStack
implements IntStack {
    protected abstract IntArrayList getDelegate();

    protected void checkEmptyStack() {
        if (this.getDelegate().isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public int peek() {
        this.checkEmptyStack();
        return this.getDelegate().getLast();
    }

    public IntList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new IntArrayList(0);
        }
        IntArrayList subList = new IntArrayList(count);
        int index = this.getDelegate().size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.getDelegate().get(index - i));
        }
        return subList;
    }

    public int peekAt(int index) {
        this.rangeCheck(index);
        return this.getDelegate().get(this.getDelegate().size() - 1 - index);
    }

    protected void rangeCheck(int index) {
        if (index < 0 || index > this.getDelegate().size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.getDelegate().size() - 1));
        }
    }

    protected void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    protected void checkSizeLessThanCount(int count) {
        if (this.getDelegate().size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.getDelegate().size());
        }
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.getDelegate().asReversed().intIterator());
    }

    public void each(IntProcedure procedure) {
        this.getDelegate().asReversed().forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.getDelegate().asReversed().count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.getDelegate().asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.getDelegate().asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.getDelegate().asReversed().noneSatisfy(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.getDelegate().asReversed().detectIfNone(predicate, ifNone);
    }

    public int[] toArray() {
        return this.getDelegate().asReversed().toArray();
    }

    public int[] toArray(int[] target) {
        return this.getDelegate().asReversed().toArray(target);
    }

    public boolean contains(int value) {
        return this.getDelegate().asReversed().contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        return this.getDelegate().toReversed().injectInto(injectedValue, function);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int size() {
        return this.getDelegate().size();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyIntIterable iterable = this.getDelegate().asReversed();
        IntIterator iterator = iterable.intIterator();
        while (iterator.hasNext()) {
            int item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.getDelegate().asReversed().toString();
    }

    public String makeString() {
        return this.getDelegate().asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.getDelegate().asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.getDelegate().asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.getDelegate().asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.getDelegate().asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.getDelegate().asReversed().appendString(appendable, start, separator, end);
    }

    public int getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(int value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public RichIterable<IntIterable> chunk(int size) {
        return this.getDelegate().asReversed().chunk(size);
    }

    public long sum() {
        return this.getDelegate().sum();
    }

    public int max() {
        return this.getDelegate().max();
    }

    public int min() {
        return this.getDelegate().min();
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        return this.getDelegate().average();
    }

    public double median() {
        return this.getDelegate().median();
    }

    public int[] toSortedArray() {
        return this.getDelegate().toSortedArray();
    }
}

