/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.NodesConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class AddressBookHelper {
    private AddressBookHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void writeCertificatePemFile(@NonNull Path pemFile, @NonNull byte[] x509Encoding) throws IOException {
        AddressBookHelper.writeCertificatePemFile(x509Encoding, new FileOutputStream(pemFile.toFile()));
    }

    public static void writeCertificatePemFile(@NonNull byte[] x509Encoding, @NonNull OutputStream out) throws IOException {
        Objects.requireNonNull(x509Encoding);
        Objects.requireNonNull(out);
        try (OutputStreamWriter writer = new OutputStreamWriter(out);
             PemWriter pemWriter = new PemWriter((Writer)writer);){
            pemWriter.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", x509Encoding));
        }
    }

    public static X509Certificate readCertificatePemFile(@NonNull Path pemFile) throws IOException, CertificateException {
        return AddressBookHelper.readCertificatePemFile(Files.newInputStream(pemFile, new OpenOption[0]));
    }

    public static X509Certificate readCertificatePemFile(@NonNull InputStream in) throws IOException, CertificateException {
        Objects.requireNonNull(in);
        try (PEMParser parser = new PEMParser((Reader)new InputStreamReader(in));){
            Object entry = parser.readObject();
            if (entry != null) {
                if (entry instanceof X509CertificateHolder) {
                    X509CertificateHolder ch = (X509CertificateHolder)entry;
                    X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(ch);
                    return x509Certificate;
                }
                throw new CertificateException("Not X509 Certificate, it is " + entry.getClass().getSimpleName());
            }
        }
        throw new CertificateException("No X509 Certificate found in the PEM file");
    }

    public static Path loadResourceFile(String resourceFileName) {
        return Path.of(Objects.requireNonNull(AddressBookHelper.class.getClassLoader().getResource(resourceFileName)).getPath(), new String[0]);
    }

    public static void checkDABEnabled(@NonNull FeeContext feeContext) {
        NodesConfig nodeConfig = (NodesConfig)Objects.requireNonNull(feeContext.configuration()).getConfigData(NodesConfig.class);
        HandleException.validateTrue((boolean)nodeConfig.enableDAB(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
    }
}

