/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeResponse;
import com.swirlds.virtualmap.internal.reconnect.TeacherPullVirtualTreeReceiveTask;
import com.swirlds.virtualmap.internal.reconnect.VirtualReconnectUtils;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public final class TeacherPullVirtualTreeView
extends VirtualTreeViewBase
implements TeacherTreeView<Long> {
    private static final Logger logger = LogManager.getLogger(TeacherPullVirtualTreeView.class);
    private final ReconnectConfig reconnectConfig;
    private final RecordAccessor records;

    public TeacherPullVirtualTreeView(ThreadManager threadManager, ReconnectConfig reconnectConfig, VirtualMap map, VirtualMapMetadata state, VirtualPipeline pipeline) {
        super(map, state, state);
        this.reconnectConfig = reconnectConfig;
        this.records = (RecordAccessor)pipeline.pausePipelineAndRun("copy", map::detach);
    }

    public void startTeacherTasks(TeachingSynchronizer teachingSynchronizer, Time time, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream) {
        AsyncOutputStream out = teachingSynchronizer.buildOutputStream(workGroup, (SerializableDataOutputStream)outputStream);
        out.start();
        TeacherPullVirtualTreeReceiveTask teacherReceiveTask = new TeacherPullVirtualTreeReceiveTask(time, this.reconnectConfig, workGroup, (SerializableDataInputStream)inputStream, (AsyncOutputStream<PullVirtualTreeResponse>)out, this);
        teacherReceiveTask.exec();
    }

    private boolean isLeaf(long path) {
        return path >= this.reconnectState.getFirstLeafPath() && path <= this.reconnectState.getLastLeafPath();
    }

    public void writeNode(SerializableDataOutputStream out, long path, boolean isClean) throws IOException {
        this.checkValidNode(path, this.reconnectState);
        if (path == 0L) {
            out.writeLong(this.reconnectState.getFirstLeafPath());
            out.writeLong(this.reconnectState.getLastLeafPath());
        }
        if (!isClean && this.isLeaf(path) && this.reconnectState.getFirstLeafPath() > 0L) {
            VirtualReconnectUtils.writeLeafRecord(out, this.records.findLeafRecord(path));
        }
    }

    public Hash loadHash(long path) {
        return this.records.findHash(path);
    }

    public void addToHandleQueue(Long node) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.addToHandleQueue()");
    }

    public Long getNextNodeToHandle() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.getNextNodeToHandle()");
    }

    public boolean areThereNodesToHandle() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.areThereNodesToHandle()");
    }

    public Long getChildAndPrepareForQueryResponse(Long parent, int childIndex) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.getChildAndPrepareForQueryResponse()");
    }

    public Long getNodeForNextResponse() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.getNodeForNextResponse()");
    }

    public boolean isResponseExpected() {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.isResponseExpected()");
    }

    public void registerResponseForNode(Long node, boolean learnerHasNode) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.registerResponseForNode()");
    }

    public boolean hasLearnerConfirmedFor(Long node) {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.hasLearnerConfirmedFor()");
    }

    public void serializeLeaf(SerializableDataOutputStream out, Long leaf) throws IOException {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.serializeLeaf()");
    }

    public void serializeInternal(SerializableDataOutputStream out, Long internal) throws IOException {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.serializeInternal()");
    }

    public void writeChildHashes(Long parent, SerializableDataOutputStream out) throws IOException {
        throw new UnsupportedOperationException("TeacherPullVirtualTreeView.writeChildHashes()");
    }

    public void close() {
        try {
            this.records.close();
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "interrupted while attempting to close data source");
        }
    }
}

