/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.NodePayments;
import com.hedera.node.app.service.token.impl.ReadableNodePaymentsStoreImpl;
import com.hedera.node.app.service.token.impl.schemas.V0700TokenSchema;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;

public class WritableNodePaymentsStore
extends ReadableNodePaymentsStoreImpl {
    private final WritableSingletonState<NodePayments> nodePaymentsState;

    public WritableNodePaymentsStore(@NonNull WritableStates states) {
        super((ReadableStates)states);
        this.nodePaymentsState = Objects.requireNonNull(states).getSingleton(V0700TokenSchema.NODE_PAYMENTS_STATE_ID);
    }

    public void put(@NonNull NodePayments nodePayments) {
        Objects.requireNonNull(nodePayments);
        this.nodePaymentsState.put((Object)nodePayments);
    }

    public void resetForNewStakingPeriod(Timestamp lastNodeFeeDistributionTime) {
        this.nodePaymentsState.put((Object)NodePayments.newBuilder().payments(List.of()).lastNodeFeeDistributionTime(lastNodeFeeDistributionTime).build());
    }
}

