/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoGetInfoQuery;
import com.hedera.hapi.node.token.CryptoGetInfoResponse;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.crypto.ExtantCryptoContext;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.api.AccountSummariesApi;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.StakingConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.InstantSource;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoGetAccountInfoHandler
extends PaidQueryHandler {
    private final CryptoOpsUsage cryptoOpsUsage;
    private final InstantSource instantSource;

    @Inject
    public CryptoGetAccountInfoHandler(@NonNull CryptoOpsUsage cryptoOpsUsage, @NonNull InstantSource instantSource) {
        this.cryptoOpsUsage = Objects.requireNonNull(cryptoOpsUsage);
        this.instantSource = Objects.requireNonNull(instantSource);
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.cryptoGetInfoOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        CryptoGetInfoResponse.Builder response = CryptoGetInfoResponse.newBuilder().header(Objects.requireNonNull(header));
        return Response.newBuilder().cryptoGetInfo(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        Query query = context.query();
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        CryptoGetInfoQuery op = query.cryptoGetInfoOrThrow();
        if (!op.hasAccountID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        Account account = accountStore.getAliasedAccountById(Objects.requireNonNull(op.accountID()));
        PreCheckException.validateFalsePreCheck((account == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        PreCheckException.validateFalsePreCheck((boolean)account.deleted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_DELETED);
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        Query query = context.query();
        CryptoGetInfoQuery op = query.cryptoGetInfoOrThrow();
        CryptoGetInfoResponse.Builder response = CryptoGetInfoResponse.newBuilder();
        AccountID accountId = op.accountIDOrElse(AccountID.DEFAULT);
        response.header(header);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            Optional<CryptoGetInfoResponse.AccountInfo> optionalInfo = this.infoForAccount(accountId, context);
            if (optionalInfo.isPresent()) {
                response.accountInfo(optionalInfo.get());
            } else {
                response.header(ResponseHeader.newBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.FAIL_INVALID).cost(0L));
            }
        }
        return Response.newBuilder().cryptoGetInfo(response).build();
    }

    private Optional<CryptoGetInfoResponse.AccountInfo> infoForAccount(@NonNull AccountID accountID, @NonNull QueryContext context) {
        Objects.requireNonNull(accountID);
        Objects.requireNonNull(context);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        StakingConfig stakingConfig = (StakingConfig)context.configuration().getConfigData(StakingConfig.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        ReadableTokenRelationStore tokenRelationStore = (ReadableTokenRelationStore)context.createStore(ReadableTokenRelationStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableStakingInfoStore stakingInfoStore = (ReadableStakingInfoStore)context.createStore(ReadableStakingInfoStore.class);
        ReadableNetworkStakingRewardsStore stakingRewardsStore = (ReadableNetworkStakingRewardsStore)context.createStore(ReadableNetworkStakingRewardsStore.class);
        Account account = accountStore.getAliasedAccountById(accountID);
        if (account == null) {
            return Optional.empty();
        }
        CryptoGetInfoResponse.AccountInfo.Builder info = CryptoGetInfoResponse.AccountInfo.newBuilder();
        info.ledgerId(ledgerConfig.id());
        info.key(account.key());
        info.accountID(account.accountIdOrThrow());
        info.receiverSigRequired(account.receiverSigRequired());
        info.deleted(account.deleted());
        info.memo(account.memo());
        info.autoRenewPeriod(Duration.newBuilder().seconds(account.autoRenewSeconds()));
        info.balance(account.tinybarBalance());
        info.expirationTime(Timestamp.newBuilder().seconds(account.expirationSecond()));
        info.contractAccountID(AccountSummariesApi.hexedEvmAddressOf((Account)account));
        info.ownedNfts(account.numberOwnedNfts());
        info.maxAutomaticTokenAssociations(account.maxAutoAssociations());
        info.ethereumNonce(account.ethereumNonce());
        if (!AliasUtils.isOfEvmAddressSize((Bytes)account.alias())) {
            info.alias(account.alias());
        }
        if (tokensConfig.balancesInQueriesEnabled()) {
            info.tokenRelationships(AccountSummariesApi.tokenRelationshipsOf((Account)account, (ReadableTokenStore)tokenStore, (ReadableTokenRelationStore)tokenRelationStore, (long)tokensConfig.maxRelsPerInfoQuery()));
        }
        info.stakingInfo(AccountSummariesApi.summarizeStakingInfo((int)stakingConfig.rewardHistoryNumStoredPeriods(), (long)stakingConfig.periodMins(), (boolean)stakingRewardsStore.isStakingRewardsActivated(), (Account)account, (ReadableStakingInfoStore)stakingInfoStore, (Instant)this.instantSource.instant()));
        return Optional.of(info.build());
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        Query query = queryContext.query();
        ReadableAccountStore accountStore = (ReadableAccountStore)queryContext.createStore(ReadableAccountStore.class);
        CryptoGetInfoQuery op = query.cryptoGetInfoOrThrow();
        AccountID accountId = op.accountIDOrElse(AccountID.DEFAULT);
        Account account = accountStore.getAliasedAccountById(accountId);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGiven(query, account));
    }

    private FeeData usageGiven(Query query, Account account) {
        if (account == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        ExtantCryptoContext ctx = ExtantCryptoContext.newBuilder().setCurrentKey(CommonPbjConverters.fromPbj((Key)account.keyOrThrow())).setCurrentMemo(account.memo()).setCurrentExpiry(account.expirationSecond()).setCurrentNumTokenRels(account.numberAssociations()).setCurrentMaxAutomaticAssociations(account.maxAutoAssociations()).setCurrentCryptoAllowances(Collections.emptyMap()).setCurrentTokenAllowances(Collections.emptyMap()).setCurrentApproveForAllNftAllowances(Collections.emptySet()).setCurrentlyHasProxy(false).build();
        return this.cryptoOpsUsage.cryptoInfoUsage(CommonPbjConverters.fromPbj((Query)query), ctx);
    }
}

