/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class BaseFeeOperation
extends AbstractFixedCostOperation {
    public BaseFeeOperation(GasCalculator gasCalculator) {
        super(72, "BASEFEE", 0, 1, gasCalculator, gasCalculator.getBaseTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Optional<Wei> maybeBaseFee = frame.getBlockValues().getBaseFee();
        if (maybeBaseFee.isEmpty()) {
            return new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INVALID_OPERATION);
        }
        frame.pushStackItem((Bytes)maybeBaseFee.orElseThrow());
        return this.successResponse;
    }
}

