/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.TransferAuditTest;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.Objects;

public class SystemAccountCreditScreen {
    public static final SystemAccountCreditScreen SYSTEM_ACCOUNT_CREDIT_SCREEN = new SystemAccountCreditScreen();
    private static final TransferAuditTest SYSTEM_ACCOUNT_CREDIT_TEST = new TransferAuditTest(){

        @Override
        public boolean flagsAdjustment(@NonNull AccountAmount adjust) {
            Objects.requireNonNull(adjust);
            return SystemAccountCreditScreen.creditsSystemAccount(adjust);
        }

        @Override
        public boolean flagsNftTransfer(@NonNull NftTransfer nftTransfer) {
            Objects.requireNonNull(nftTransfer);
            return SystemAccountCreditScreen.isSystemAccountNumber(nftTransfer.receiverAccountIDOrThrow().accountNumOrElse(Long.valueOf(0L)));
        }
    };

    private SystemAccountCreditScreen() {
    }

    public boolean creditsToSystemAccount(@NonNull CryptoTransferTransactionBody op) {
        return TransferAuditTest.isAuditFlagRaised(op, SYSTEM_ACCOUNT_CREDIT_TEST);
    }

    private static boolean creditsSystemAccount(@NonNull AccountAmount adjust) {
        Long accountNumber = adjust.accountIDOrThrow().accountNumOrElse(Long.valueOf(0L));
        return adjust.amount() > 0L && (SystemAccountCreditScreen.isSystemAccountNumber(accountNumber) || SystemAccountCreditScreen.isSystemAccountAlias(adjust.accountID()));
    }

    private static boolean isSystemAccountNumber(long number) {
        return number > 0L && number <= 750L;
    }

    private static boolean isSystemAccountAlias(@Nullable AccountID accountID) {
        byte[] alias = accountID.aliasOrElse(Bytes.EMPTY).toByteArray();
        if (alias.length > 0) {
            int aliasToNumber = new BigInteger(alias).intValue();
            return aliasToNumber > 0 && aliasToNumber <= 750;
        }
        return false;
    }
}

