/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers;

import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExceptionHandlers {
    public static final Thread.UncaughtExceptionHandler RETHROW_UNCAUGHT_EXCEPTION = ExceptionHandlers::rethrowException;
    public static final Thread.UncaughtExceptionHandler NOOP_UNCAUGHT_EXCEPTION = ExceptionHandlers::ignoreException;

    @NonNull
    public static Thread.UncaughtExceptionHandler defaultExceptionHandler(@NonNull String name) {
        return new DefaultUncaughtExceptionHandler(name);
    }

    private ExceptionHandlers() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static void rethrowException(@NonNull Thread thread, @NonNull Throwable exception) {
        if (exception instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)exception;
            throw runtimeException;
        }
        throw new RuntimeException("Uncaught exception in wiring", exception);
    }

    private static void ignoreException(@NonNull Thread thread, @NonNull Throwable exception) {
    }

    private record DefaultUncaughtExceptionHandler(@NonNull String name) implements Thread.UncaughtExceptionHandler
    {
        private static final Logger logger = LogManager.getLogger(DefaultUncaughtExceptionHandler.class);

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Uncaught exception in {}", (Object)this.name, (Object)exception);
        }
    }
}

