/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.platform.internal.Deserializer;
import com.swirlds.platform.internal.Serializer;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.hiero.base.crypto.CryptoUtils;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public final class Utilities {
    private Utilities() {
    }

    @Deprecated
    public static <T> void writeList(List<T> list, SerializableDataOutputStream stream, Serializer<T> serializer) throws IOException {
        if (list == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(list.size());
        for (T t : list) {
            serializer.serialize(t, stream);
        }
    }

    @Deprecated
    public static <T> List<T> readList(SerializableDataInputStream stream, Supplier<List<T>> listSupplier, Deserializer<T> deserializer) throws IOException {
        int listSize = stream.readInt();
        if (listSize < 0) {
            return null;
        }
        List<T> list = listSupplier.get();
        for (int i = 0; i < listSize; ++i) {
            list.add(deserializer.deserialize(stream));
        }
        return list;
    }

    public static byte[] toBytes(long n) {
        byte[] bytes = new byte[8];
        Utilities.toBytes(n, bytes, 0);
        return bytes;
    }

    public static void toBytes(long n, byte[] bytes, int start) {
        for (int i = start + 8 - 1; i >= start; --i) {
            bytes[i] = (byte)n;
            n >>>= 8;
        }
    }

    public static long toLong(byte[] b) {
        return Utilities.toLong(b, 0);
    }

    public static long toLong(byte[] b, int start) {
        long result = 0L;
        for (int i = start; i < start + 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }

    public static boolean isOrCausedBySocketException(Throwable ex) {
        return Utilities.isRootCauseSuppliedType(ex, SocketException.class);
    }

    public static boolean isCausedByIOException(Exception e) {
        return Utilities.isRootCauseSuppliedType(e, IOException.class);
    }

    public static boolean isRootCauseSuppliedType(Throwable t, Class<? extends Throwable> type) {
        if (t == null) {
            return false;
        }
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return type.isInstance(cause);
    }

    public static boolean hasAnyCauseSuppliedType(@NonNull Throwable throwable, @NonNull Class<? extends Throwable> type) {
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            if (!type.isInstance(cause)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static List<PeerInfo> createPeerInfoList(@NonNull Roster roster, @NonNull NodeId selfId) {
        Objects.requireNonNull(roster);
        Objects.requireNonNull(selfId);
        return roster.rosterEntries().stream().filter(entry -> entry.nodeId() != selfId.id()).filter(entry -> CryptoUtils.checkCertificate((Certificate)RosterUtils.fetchGossipCaCertificate((RosterEntry)entry))).map(Utilities::toPeerInfo).toList();
    }

    @NonNull
    public static PeerInfo toPeerInfo(@NonNull RosterEntry entry) {
        Objects.requireNonNull(entry);
        return new PeerInfo(NodeId.of((long)entry.nodeId()), Objects.requireNonNull(RosterUtils.fetchHostname((RosterEntry)entry, (int)0)), RosterUtils.fetchPort((RosterEntry)entry, (int)0), Objects.requireNonNull(RosterUtils.fetchGossipCaCertificate((RosterEntry)entry)));
    }
}

