/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.logging;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HtmlTagFactory {
    private final Map<String, List<String>> attributeMap = new HashMap<String, List<String>>();
    private final String tagName;
    private final String content;

    public HtmlTagFactory(@NonNull String tagName, @NonNull String content) {
        this.tagName = Objects.requireNonNull(tagName);
        this.content = Objects.requireNonNull(content);
    }

    public HtmlTagFactory(@NonNull String tagName) {
        this.tagName = Objects.requireNonNull(tagName);
        this.content = null;
    }

    @NonNull
    public HtmlTagFactory addAttribute(@NonNull String attributeName, @NonNull List<String> values) {
        if (this.attributeMap.containsKey(attributeName)) {
            this.attributeMap.get(attributeName).addAll(values);
        } else {
            this.attributeMap.put(attributeName, new ArrayList<String>(values));
        }
        return this;
    }

    @NonNull
    public HtmlTagFactory addAttribute(@NonNull String attributeName, @NonNull String value) {
        if (this.attributeMap.containsKey(attributeName)) {
            this.attributeMap.get(attributeName).add(value);
        } else {
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add(value);
            this.attributeMap.put(attributeName, attributeList);
        }
        return this;
    }

    @NonNull
    public HtmlTagFactory addClass(@NonNull String className) {
        return this.addAttribute("class", className);
    }

    @NonNull
    public HtmlTagFactory addClasses(@NonNull List<String> classNames) {
        return this.addAttribute("class", classNames);
    }

    @NonNull
    public HtmlTagFactory addClasses(String ... classNames) {
        return this.addClasses(List.of(classNames));
    }

    @NonNull
    public String generateTag() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.tagName);
        ArrayList<CallSite> attributeStrings = new ArrayList<CallSite>();
        for (Map.Entry<String, List<String>> entry : this.attributeMap.entrySet()) {
            String attributeStringBuilder = entry.getKey() + "=\"" + String.join((CharSequence)" ", (Iterable<? extends CharSequence>)entry.getValue()) + "\"";
            attributeStrings.add((CallSite)((Object)attributeStringBuilder));
        }
        if (!attributeStrings.isEmpty()) {
            stringBuilder.append(" ");
            stringBuilder.append(String.join((CharSequence)" ", attributeStrings));
        }
        if (this.content == null) {
            stringBuilder.append(">");
            return stringBuilder.toString();
        }
        stringBuilder.append(">");
        stringBuilder.append(this.content);
        stringBuilder.append("</");
        stringBuilder.append(this.tagName);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

