/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.cli.utility;

import com.swirlds.base.formatting.TextEffect;

public final class PlatformCliLogo {
    public static final String LOGO = " .----------------.  .----------------.  .----------------.  .----------------.\n| .--------------. || .--------------. || .--------------. || .--------------. |\n| |   ______     | || |     ______   | || |   _____      | || |     _____    | |\n| |  |_   __ \\   | || |   .' ___  |  | || |  |_   _|     | || |    |_   _|   | |\n| |    | |__) |  | || |  / .'   \\_|  | || |    | |       | || |      | |     | |\n| |    |  ___/   | || |  | |         | || |    | |   _   | || |      | |     | |\n| |   _| |_      | || |  \\ `.___.'\\  | || |   _| |__/ |  | || |     _| |_    | |\n| |  |_____|     | || |   `._____.'  | || |  |________|  | || |    |_____|   | |\n| |              | || |              | || |              | || |              | |\n| '--------------' || '--------------' || '--------------' || '--------------' |\n '----------------'  '----------------'  '----------------'  '----------------'\n";

    private PlatformCliLogo() {
    }

    public static String getColorizedLogo() {
        if (!TextEffect.areTextEffectsEnabled()) {
            return LOGO;
        }
        StringBuilder sb = new StringBuilder();
        TextEffect outerBoxColor = TextEffect.BRIGHT_WHITE;
        TextEffect pInnerBoxColor = TextEffect.RED;
        TextEffect innerBoxColor = TextEffect.YELLOW;
        TextEffect pColor = TextEffect.BRIGHT_RED;
        TextEffect letterColor = TextEffect.BRIGHT_YELLOW;
        String[] lines = LOGO.split("\n");
        int boxWidth = lines[1].length() / 4;
        int boxEdgeWidth = 3;
        int letterWidth = boxWidth - 6;
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            String line = lines[lineNumber];
            if (lineNumber == 0 || lineNumber == lines.length - 1) {
                outerBoxColor.apply(sb, line);
            } else if (lineNumber == 1 || lineNumber == lines.length - 2) {
                end = 0;
                for (letterIndex = 0; letterIndex < 4; ++letterIndex) {
                    start = end++;
                    outerBoxColor.apply(sb, line.substring(start, end));
                    start = end;
                    end += boxWidth - 2;
                    if (letterIndex == 0) {
                        pInnerBoxColor.apply(sb, line.substring(start, end));
                    } else {
                        innerBoxColor.apply(sb, line.substring(start, end));
                    }
                    start = end++;
                    outerBoxColor.apply(sb, line.substring(start, end));
                }
            } else {
                end = 0;
                for (letterIndex = 0; letterIndex < 4; ++letterIndex) {
                    start = end++;
                    outerBoxColor.apply(sb, line.substring(start, end));
                    start = end;
                    end += 2;
                    if (letterIndex == 0) {
                        pInnerBoxColor.apply(sb, line.substring(start, end));
                    } else {
                        innerBoxColor.apply(sb, line.substring(start, end));
                    }
                    start = end;
                    end += letterWidth;
                    if (letterIndex == 0) {
                        pColor.apply(sb, line.substring(start, end));
                    } else {
                        letterColor.apply(sb, line.substring(start, end));
                    }
                    start = end;
                    end += 2;
                    if (letterIndex == 0) {
                        pInnerBoxColor.apply(sb, line.substring(start, end));
                    } else {
                        innerBoxColor.apply(sb, line.substring(start, end));
                    }
                    start = end++;
                    outerBoxColor.apply(sb, line.substring(start, end));
                }
            }
            if (lineNumber + 1 >= lines.length) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

