/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl;

import com.google.auto.service.AutoService;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.input.InputWire;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Objects;
import org.hiero.base.crypto.BytesSigner;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.creator.config.EventCreationConfig;
import org.hiero.consensus.event.creator.config.EventCreationWiringConfig;
import org.hiero.consensus.event.creator.impl.DefaultEventCreationManager;
import org.hiero.consensus.event.creator.impl.EventCreationManager;
import org.hiero.consensus.event.creator.impl.tipset.TipsetEventCreator;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.gossip.SyncProgress;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;

@AutoService(value={EventCreatorModule.class})
public class DefaultEventCreatorModule
implements EventCreatorModule {
    @Nullable
    private ComponentWiring<EventCreationManager, PlatformEvent> eventCreationManagerWiring;

    public void initialize(@NonNull WiringModel model, @NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull SecureRandom random, @NonNull KeysAndCerts keysAndCerts, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull EventTransactionSupplier transactionSupplier, @NonNull SignatureTransactionCheck signatureTransactionCheck) {
        if (this.eventCreationManagerWiring != null) {
            throw new IllegalStateException("Already initialized");
        }
        EventCreationConfig eventCreationConfig = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        EventCreationWiringConfig wiringConfig = (EventCreationWiringConfig)configuration.getConfigData(EventCreationWiringConfig.class);
        this.eventCreationManagerWiring = new ComponentWiring(model, EventCreationManager.class, wiringConfig.eventCreationManager());
        model.buildHeartbeatWire(eventCreationConfig.creationAttemptRate()).solderTo(this.eventCreationManagerWiring.getInputWire(EventCreationManager::maybeCreateEvent, "heartbeat"), SolderType.OFFER);
        this.eventCreationManagerWiring.getInputWire(EventCreationManager::clear);
        this.eventCreationManagerWiring.getInputWire(EventCreationManager::quiescenceCommand);
        PlatformSigner bytesSigner = new PlatformSigner(keysAndCerts);
        TipsetEventCreator eventCreator = new TipsetEventCreator(configuration, metrics, time, random, (BytesSigner)bytesSigner, roster, selfId, transactionSupplier);
        DefaultEventCreationManager eventCreationManager = new DefaultEventCreationManager(configuration, metrics, time, signatureTransactionCheck, eventCreator, roster, selfId);
        this.eventCreationManagerWiring.bind((Object)eventCreationManager);
    }

    @NonNull
    public OutputWire<PlatformEvent> createdEventOutputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getOutputWire();
    }

    @NonNull
    public InputWire<PlatformEvent> orderedEventInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::registerEvent);
    }

    @NonNull
    public InputWire<EventWindow> eventWindowInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::setEventWindow, "event window");
    }

    @NonNull
    public InputWire<PlatformStatus> platformStatusInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::updatePlatformStatus, "PlatformStatus");
    }

    @NonNull
    public InputWire<Duration> healthStatusInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::reportUnhealthyDuration, "health info");
    }

    @NonNull
    public InputWire<SyncProgress> syncProgressInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::reportSyncProgress);
    }

    @NonNull
    public InputWire<QuiescenceCommand> quiescenceCommandInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::quiescenceCommand);
    }

    public void destroy() {
        throw new UnsupportedOperationException("Shutdown mechanism not implemented yet");
    }

    public void startSquelching() {
        Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").startSquelching();
    }

    public void flush() {
        Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").flush();
    }

    public void stopSquelching() {
        Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").stopSquelching();
    }

    @NonNull
    public InputWire<Object> clearCreationMangerInputWire() {
        return Objects.requireNonNull(this.eventCreationManagerWiring, "Not initialized").getInputWire(EventCreationManager::clear);
    }
}

