/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.consensus.ConsensusSubmitMessageTransactionBody;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ConsensusSubmitMessageFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        boolean hasCustomFees;
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE);
        feeResult.addServiceFee(1L, serviceDef.baseFee());
        ConsensusSubmitMessageTransactionBody op = txnBody.consensusSubmitMessageOrThrow();
        long msgSize = op.message().length();
        this.addExtraFee(feeResult, serviceDef, Extra.BYTES, feeSchedule, msgSize);
        Topic topic = ((ReadableTopicStore)feeContext.readableStore(ReadableTopicStore.class)).getTopic(op.topicIDOrThrow());
        boolean bl = hasCustomFees = topic != null && !topic.customFees().isEmpty();
        if (hasCustomFees) {
            this.addExtraFee(feeResult, serviceDef, Extra.CONSENSUS_SUBMIT_MESSAGE_WITH_CUSTOM_FEE, feeSchedule, 1L);
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CONSENSUS_SUBMIT_MESSAGE;
    }
}

