/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.converter;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.config.types.HederaFunctionalitySet;
import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class FunctionalitySetConverter
implements ConfigConverter<HederaFunctionalitySet> {
    private static final String PATTERN = Pattern.quote(",");

    @NonNull
    public HederaFunctionalitySet convert(@NonNull String value) throws IllegalArgumentException {
        String[] entries = value.split(PATTERN, 0);
        if (entries == null || entries.length < 1) {
            throw new IllegalArgumentException("Invalid HederaFunctionality Set: %s.".formatted(value));
        }
        TreeSet<HederaFunctionality> conversions = new TreeSet<HederaFunctionality>();
        for (String entry : entries) {
            if (conversions.add(HederaFunctionality.fromString((String)entry))) continue;
            throw new IllegalArgumentException("Invalid HederaFunctionality name: %s.".formatted(entry));
        }
        return new HederaFunctionalitySet(conversions);
    }
}

