/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.common.EntityIDPair;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.token.impl.ReadableTokenRelationStoreImpl;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Set;

public class WritableTokenRelationStore
extends ReadableTokenRelationStoreImpl {
    private final WritableKVState<EntityIDPair, TokenRelation> tokenRelState;
    private final WritableEntityCounters entityCounters;

    public WritableTokenRelationStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.tokenRelState = Objects.requireNonNull(states).get(V0490TokenSchema.TOKEN_RELS_STATE_ID);
        this.entityCounters = entityCounters;
    }

    public void put(@NonNull TokenRelation tokenRelation) {
        WritableAccountStore.requireNotDefault(tokenRelation.accountIdOrThrow());
        WritableTokenStore.requireNotDefault(tokenRelation.tokenIdOrThrow());
        this.tokenRelState.put((Object)EntityIDPair.newBuilder().accountId(tokenRelation.accountId()).tokenId(tokenRelation.tokenId()).build(), (Object)Objects.requireNonNull(tokenRelation));
    }

    public void putAndIncrementCount(@NonNull TokenRelation tokenRelation) {
        this.put(tokenRelation);
        this.entityCounters.incrementEntityTypeCount(EntityType.TOKEN_ASSOCIATION);
    }

    public void remove(@NonNull TokenRelation tokenRelation) {
        this.tokenRelState.remove((Object)EntityIDPair.newBuilder().accountId(tokenRelation.accountId()).tokenId(tokenRelation.tokenId()).build());
        this.entityCounters.decrementEntityTypeCounter(EntityType.TOKEN_ASSOCIATION);
    }

    @Nullable
    public TokenRelation getOriginalValue(@NonNull AccountID accountId, @NonNull TokenID tokenId) {
        Objects.requireNonNull(accountId);
        Objects.requireNonNull(tokenId);
        return (TokenRelation)this.tokenRelState.getOriginalValue((Object)EntityIDPair.newBuilder().accountId(accountId).tokenId(tokenId).build());
    }

    public Set<EntityIDPair> modifiedTokens() {
        return this.tokenRelState.modifiedKeys();
    }
}

