/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.blockhash.BlockHashLookup;
import org.hyperledger.besu.evm.frame.BlockValues;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class BlockHashOperation
extends AbstractOperation {
    private static final int MAX_BLOCK_ARG_SIZE = 8;

    public BlockHashOperation(GasCalculator gasCalculator) {
        super(64, "BLOCKHASH", 1, 1, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long cost = this.gasCalculator().getBlockHashOperationGasCost();
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Bytes blockArg = frame.popStackItem().trimLeadingZeros();
        if (blockArg.size() > 8) {
            frame.pushStackItem((Bytes)Hash.ZERO);
            return new Operation.OperationResult(cost, null);
        }
        long soughtBlock = blockArg.toLong();
        BlockValues blockValues = frame.getBlockValues();
        long currentBlockNumber = blockValues.getNumber();
        BlockHashLookup blockHashLookup = frame.getBlockHashLookup();
        if (soughtBlock < 0L || soughtBlock >= currentBlockNumber || soughtBlock < currentBlockNumber - blockHashLookup.getLookback()) {
            frame.pushStackItem((Bytes)Bytes32.ZERO);
        } else {
            Hash blockHash = (Hash)blockHashLookup.apply(frame, soughtBlock);
            frame.pushStackItem((Bytes)blockHash);
        }
        return new Operation.OperationResult(cost, null);
    }

    protected long cost() {
        return this.gasCalculator().getBlockHashOperationGasCost();
    }
}

