/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.statistics.cycle;

import com.swirlds.metrics.api.Metrics;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.hiero.consensus.metrics.statistics.AverageAndMax;
import org.hiero.consensus.metrics.statistics.cycle.CycleBusyTime;
import org.hiero.consensus.metrics.statistics.cycle.CycleDefinition;
import org.hiero.consensus.metrics.statistics.cycle.CycleMetrics;
import org.hiero.consensus.metrics.statistics.cycle.IntervalPercentageMetric;
import org.hiero.consensus.metrics.statistics.simple.AccumulatedAverageTime;

public class AccumulatedCycleMetrics
implements CycleMetrics {
    private final CycleDefinition definition;
    private final AccumulatedAverageTime avgCycleTime;
    private final CycleBusyTime busyFraction;
    private final IntervalPercentageMetric[] intervalFraction;
    private final AverageAndMax[] intervalAvgMax;

    public AccumulatedCycleMetrics(Metrics metrics, CycleDefinition definition) {
        this.definition = definition;
        this.avgCycleTime = new AccumulatedAverageTime(metrics, definition.getCategory(), definition.getName() + "-avgTime", "average time for a single cycle " + definition.getName());
        this.busyFraction = new CycleBusyTime(metrics, definition.getCategory(), definition.getName() + "-busy", "the percentage of time the thread is busy ");
        this.intervalFraction = new IntervalPercentageMetric[definition.getNumIntervals()];
        this.intervalAvgMax = new AverageAndMax[definition.getNumIntervals()];
        for (int i = 0; i < definition.getNumIntervals(); ++i) {
            this.intervalFraction[i] = new IntervalPercentageMetric(metrics, definition, i);
            this.intervalAvgMax[i] = new AverageAndMax(metrics, definition.getCategory(), definition.getDisplayName(i), definition.getIntervalDescription(i), "%,8.1f");
        }
    }

    @Override
    public void intervalFinished(int interval, long durationNanos) {
        this.intervalAvgMax[interval].update(TimeUnit.NANOSECONDS.toMillis(durationNanos));
    }

    @Override
    public void cycleFinished(long[] intervalNanoTime) {
        long totalTime = Arrays.stream(intervalNanoTime).sum();
        this.busyFraction.addBusyTime(totalTime);
        this.avgCycleTime.add(totalTime);
        for (int i = 0; i < this.definition.getNumIntervals(); ++i) {
            this.intervalFraction[i].updateTime(totalTime, intervalNanoTime[i]);
        }
    }

    @Override
    public void idleTime(long nanoTime) {
        this.busyFraction.addIdleTime(nanoTime);
    }

    @Override
    public int getNumIntervals() {
        return this.definition.getNumIntervals();
    }

    public double getAvgCycleTime() {
        return this.avgCycleTime.get();
    }

    public double getBusyFraction() {
        return this.busyFraction.get();
    }

    public double getIntervalFraction(int i) {
        return this.intervalFraction[i].get();
    }
}

