/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.output;

import com.hedera.hapi.block.stream.output.CallContractOutput;
import com.hedera.hapi.block.stream.output.CreateAccountOutput;
import com.hedera.hapi.block.stream.output.CreateContractOutput;
import com.hedera.hapi.block.stream.output.CreateScheduleOutput;
import com.hedera.hapi.block.stream.output.EthereumOutput;
import com.hedera.hapi.block.stream.output.SignScheduleOutput;
import com.hedera.hapi.block.stream.output.UtilPrngOutput;
import com.hedera.hapi.block.stream.output.codec.TransactionOutputJsonCodec;
import com.hedera.hapi.block.stream.output.codec.TransactionOutputProtoCodec;
import com.hedera.hapi.block.stream.output.schema.TransactionOutputSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TransactionOutput {
    public static final Codec<TransactionOutput> PROTOBUF = new TransactionOutputProtoCodec();
    public static final JsonCodec<TransactionOutput> JSON = new TransactionOutputJsonCodec();
    public static final TransactionOutput DEFAULT = TransactionOutput.newBuilder().build();
    private final OneOf<TransactionOneOfType> transaction;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TransactionOutput(OneOf<TransactionOneOfType> transaction) {
        this.$unknownFields = null;
        if (transaction == null) {
            throw new NullPointerException("Parameter 'transaction' must be supplied and can not be null");
        }
        this.transaction = transaction;
    }

    public TransactionOutput(OneOf<TransactionOneOfType> transaction, List<UnknownField> $unknownFields) {
        List<UnknownField> list = this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        if (transaction == null) {
            throw new NullPointerException("Parameter 'transaction' must be supplied and can not be null");
        }
        this.transaction = transaction;
    }

    public OneOf<TransactionOneOfType> transaction() {
        return this.transaction;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            if (this.transaction.kind() == TransactionOneOfType.UTIL_PRNG) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.UTIL_PRNG, (Object)((UtilPrngOutput)this.transaction.as()), UtilPrngOutput.PROTOBUF);
            }
            if (this.transaction.kind() == TransactionOneOfType.CONTRACT_CALL) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.CONTRACT_CALL, (Object)((CallContractOutput)this.transaction.as()), CallContractOutput.PROTOBUF);
            }
            if (this.transaction.kind() == TransactionOneOfType.ETHEREUM_CALL) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.ETHEREUM_CALL, (Object)((EthereumOutput)this.transaction.as()), EthereumOutput.PROTOBUF);
            }
            if (this.transaction.kind() == TransactionOneOfType.CONTRACT_CREATE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.CONTRACT_CREATE, (Object)((CreateContractOutput)this.transaction.as()), CreateContractOutput.PROTOBUF);
            }
            if (this.transaction.kind() == TransactionOneOfType.CREATE_SCHEDULE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.CREATE_SCHEDULE, (Object)((CreateScheduleOutput)this.transaction.as()), CreateScheduleOutput.PROTOBUF);
            }
            if (this.transaction.kind() == TransactionOneOfType.SIGN_SCHEDULE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.SIGN_SCHEDULE, (Object)((SignScheduleOutput)this.transaction.as()), SignScheduleOutput.PROTOBUF);
            }
            if (this.transaction.kind() == TransactionOneOfType.ACCOUNT_CREATE) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionOutputSchema.ACCOUNT_CREATE, (Object)((CreateAccountOutput)this.transaction.as()), CreateAccountOutput.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.transaction != null && !this.transaction.equals(TransactionOutput.DEFAULT.transaction)) {
                result = 31 * result + this.transaction.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionOutput thatObj = (TransactionOutput)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.transaction == null && thatObj.transaction != null) {
            return false;
        }
        if (this.transaction != null && !this.transaction.equals(thatObj.transaction)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TransactionOutput[transaction=" + String.valueOf(this.transaction) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public UtilPrngOutput utilPrng() {
        return this.transaction.kind() == TransactionOneOfType.UTIL_PRNG ? (UtilPrngOutput)this.transaction.value() : null;
    }

    public boolean hasUtilPrng() {
        return this.transaction.kind() == TransactionOneOfType.UTIL_PRNG;
    }

    public UtilPrngOutput utilPrngOrElse(@NonNull UtilPrngOutput defaultValue) {
        return this.hasUtilPrng() ? this.utilPrng() : defaultValue;
    }

    @NonNull
    public UtilPrngOutput utilPrngOrThrow() {
        return Objects.requireNonNull(this.utilPrng(), "Field utilPrng is null");
    }

    @Nullable
    public CallContractOutput contractCall() {
        return this.transaction.kind() == TransactionOneOfType.CONTRACT_CALL ? (CallContractOutput)this.transaction.value() : null;
    }

    public boolean hasContractCall() {
        return this.transaction.kind() == TransactionOneOfType.CONTRACT_CALL;
    }

    public CallContractOutput contractCallOrElse(@NonNull CallContractOutput defaultValue) {
        return this.hasContractCall() ? this.contractCall() : defaultValue;
    }

    @NonNull
    public CallContractOutput contractCallOrThrow() {
        return Objects.requireNonNull(this.contractCall(), "Field contractCall is null");
    }

    @Nullable
    public EthereumOutput ethereumCall() {
        return this.transaction.kind() == TransactionOneOfType.ETHEREUM_CALL ? (EthereumOutput)this.transaction.value() : null;
    }

    public boolean hasEthereumCall() {
        return this.transaction.kind() == TransactionOneOfType.ETHEREUM_CALL;
    }

    public EthereumOutput ethereumCallOrElse(@NonNull EthereumOutput defaultValue) {
        return this.hasEthereumCall() ? this.ethereumCall() : defaultValue;
    }

    @NonNull
    public EthereumOutput ethereumCallOrThrow() {
        return Objects.requireNonNull(this.ethereumCall(), "Field ethereumCall is null");
    }

    @Nullable
    public CreateContractOutput contractCreate() {
        return this.transaction.kind() == TransactionOneOfType.CONTRACT_CREATE ? (CreateContractOutput)this.transaction.value() : null;
    }

    public boolean hasContractCreate() {
        return this.transaction.kind() == TransactionOneOfType.CONTRACT_CREATE;
    }

    public CreateContractOutput contractCreateOrElse(@NonNull CreateContractOutput defaultValue) {
        return this.hasContractCreate() ? this.contractCreate() : defaultValue;
    }

    @NonNull
    public CreateContractOutput contractCreateOrThrow() {
        return Objects.requireNonNull(this.contractCreate(), "Field contractCreate is null");
    }

    @Nullable
    public CreateScheduleOutput createSchedule() {
        return this.transaction.kind() == TransactionOneOfType.CREATE_SCHEDULE ? (CreateScheduleOutput)this.transaction.value() : null;
    }

    public boolean hasCreateSchedule() {
        return this.transaction.kind() == TransactionOneOfType.CREATE_SCHEDULE;
    }

    public CreateScheduleOutput createScheduleOrElse(@NonNull CreateScheduleOutput defaultValue) {
        return this.hasCreateSchedule() ? this.createSchedule() : defaultValue;
    }

    @NonNull
    public CreateScheduleOutput createScheduleOrThrow() {
        return Objects.requireNonNull(this.createSchedule(), "Field createSchedule is null");
    }

    @Nullable
    public SignScheduleOutput signSchedule() {
        return this.transaction.kind() == TransactionOneOfType.SIGN_SCHEDULE ? (SignScheduleOutput)this.transaction.value() : null;
    }

    public boolean hasSignSchedule() {
        return this.transaction.kind() == TransactionOneOfType.SIGN_SCHEDULE;
    }

    public SignScheduleOutput signScheduleOrElse(@NonNull SignScheduleOutput defaultValue) {
        return this.hasSignSchedule() ? this.signSchedule() : defaultValue;
    }

    @NonNull
    public SignScheduleOutput signScheduleOrThrow() {
        return Objects.requireNonNull(this.signSchedule(), "Field signSchedule is null");
    }

    @Nullable
    public CreateAccountOutput accountCreate() {
        return this.transaction.kind() == TransactionOneOfType.ACCOUNT_CREATE ? (CreateAccountOutput)this.transaction.value() : null;
    }

    public boolean hasAccountCreate() {
        return this.transaction.kind() == TransactionOneOfType.ACCOUNT_CREATE;
    }

    public CreateAccountOutput accountCreateOrElse(@NonNull CreateAccountOutput defaultValue) {
        return this.hasAccountCreate() ? this.accountCreate() : defaultValue;
    }

    @NonNull
    public CreateAccountOutput accountCreateOrThrow() {
        return Objects.requireNonNull(this.accountCreate(), "Field accountCreate is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.transaction, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum TransactionOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        UTIL_PRNG(1, "util_prng"),
        CONTRACT_CALL(2, "contract_call"),
        ETHEREUM_CALL(3, "ethereum_call"),
        CONTRACT_CREATE(4, "contract_create"),
        CREATE_SCHEDULE(5, "create_schedule"),
        SIGN_SCHEDULE(6, "sign_schedule"),
        ACCOUNT_CREATE(7, "account_create");

        private final int protoOrdinal;
        private final String protoName;

        private TransactionOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static TransactionOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> UTIL_PRNG;
                case 2 -> CONTRACT_CALL;
                case 3 -> ETHEREUM_CALL;
                case 4 -> CONTRACT_CREATE;
                case 5 -> CREATE_SCHEDULE;
                case 6 -> SIGN_SCHEDULE;
                case 7 -> ACCOUNT_CREATE;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static TransactionOneOfType fromString(String name) {
            return switch (name) {
                case "util_prng", "UTIL_PRNG" -> UTIL_PRNG;
                case "contract_call", "CONTRACT_CALL" -> CONTRACT_CALL;
                case "ethereum_call", "ETHEREUM_CALL" -> ETHEREUM_CALL;
                case "contract_create", "CONTRACT_CREATE" -> CONTRACT_CREATE;
                case "create_schedule", "CREATE_SCHEDULE" -> CREATE_SCHEDULE;
                case "sign_schedule", "SIGN_SCHEDULE" -> SIGN_SCHEDULE;
                case "account_create", "ACCOUNT_CREATE" -> ACCOUNT_CREATE;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<TransactionOneOfType> transaction = TransactionOutputProtoCodec.TRANSACTION_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(OneOf<TransactionOneOfType> transaction) {
            this.$unknownFields = null;
            this.transaction = transaction;
        }

        public Builder(OneOf<TransactionOneOfType> transaction, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.transaction = transaction;
        }

        public TransactionOutput build() {
            return new TransactionOutput(this.transaction);
        }

        public void clearTransaction() {
            this.transaction = TransactionOutputProtoCodec.TRANSACTION_UNSET;
        }

        public Builder utilPrng(@Nullable UtilPrngOutput utilPrng) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.UTIL_PRNG, (Object)utilPrng);
            return this;
        }

        public Builder utilPrng(UtilPrngOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.UTIL_PRNG, (Object)builder.build());
            return this;
        }

        public Builder contractCall(@Nullable CallContractOutput contractCall) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.CONTRACT_CALL, (Object)contractCall);
            return this;
        }

        public Builder contractCall(CallContractOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.CONTRACT_CALL, (Object)builder.build());
            return this;
        }

        public Builder ethereumCall(@Nullable EthereumOutput ethereumCall) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.ETHEREUM_CALL, (Object)ethereumCall);
            return this;
        }

        public Builder ethereumCall(EthereumOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.ETHEREUM_CALL, (Object)builder.build());
            return this;
        }

        public Builder contractCreate(@Nullable CreateContractOutput contractCreate) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.CONTRACT_CREATE, (Object)contractCreate);
            return this;
        }

        public Builder contractCreate(CreateContractOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.CONTRACT_CREATE, (Object)builder.build());
            return this;
        }

        public Builder createSchedule(@Nullable CreateScheduleOutput createSchedule) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.CREATE_SCHEDULE, (Object)createSchedule);
            return this;
        }

        public Builder createSchedule(CreateScheduleOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.CREATE_SCHEDULE, (Object)builder.build());
            return this;
        }

        public Builder signSchedule(@Nullable SignScheduleOutput signSchedule) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.SIGN_SCHEDULE, (Object)signSchedule);
            return this;
        }

        public Builder signSchedule(SignScheduleOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.SIGN_SCHEDULE, (Object)builder.build());
            return this;
        }

        public Builder accountCreate(@Nullable CreateAccountOutput accountCreate) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.ACCOUNT_CREATE, (Object)accountCreate);
            return this;
        }

        public Builder accountCreate(CreateAccountOutput.Builder builder) {
            this.transaction = new OneOf((Enum)TransactionOneOfType.ACCOUNT_CREATE, (Object)builder.build());
            return this;
        }

        public OneOf<TransactionOneOfType> transaction() {
            return this.transaction;
        }
    }
}

