/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.hapi.block.stream.output.SingletonUpdateChange;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.hapi.node.state.blockstream.BlockStreamInfo;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.congestion.CongestionLevelStarts;
import com.hedera.hapi.node.state.entity.EntityCounts;
import com.hedera.hapi.node.state.hints.CRSState;
import com.hedera.hapi.node.state.hints.HintsConstruction;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.primitives.ProtoString;
import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.hapi.node.state.token.NetworkStakingRewards;
import com.hedera.hapi.node.state.token.NodePayments;
import com.hedera.hapi.node.state.token.NodeRewards;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.node.app.service.entityid.impl.schemas.V0590EntityIdSchema;
import com.hedera.node.app.spi.metrics.StoreMetricsService;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.node.config.data.TopicsConfig;
import com.hedera.pbj.runtime.OneOf;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.spi.metrics.StoreMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;

public class BoundaryStateChangeListener
implements StateChangeListener {
    private static final Set<StateChangeListener.StateType> TARGET_DATA_TYPES = EnumSet.of(StateChangeListener.StateType.SINGLETON);
    private final SortedMap<Integer, StateChange> singletonUpdates = new TreeMap<Integer, StateChange>();
    @NonNull
    private final StoreMetricsService storeMetricsService;
    @NonNull
    private final Supplier<Configuration> configurationSupplier;
    private long nodeFeesCollected;

    public BoundaryStateChangeListener(@NonNull StoreMetricsService storeMetricsService, @NonNull Supplier<Configuration> configurationSupplier) {
        this.storeMetricsService = Objects.requireNonNull(storeMetricsService);
        this.configurationSupplier = Objects.requireNonNull(configurationSupplier);
    }

    public void resetCollectedNodeFees() {
        this.nodeFeesCollected = 0L;
    }

    public long nodeFeesCollected() {
        return this.nodeFeesCollected;
    }

    public void trackCollectedNodeFees(long nodeFeesCollected) {
        this.nodeFeesCollected += nodeFeesCollected;
    }

    public void reset() {
        this.singletonUpdates.clear();
    }

    public List<StateChange> allStateChanges() {
        LinkedList<StateChange> allStateChanges = new LinkedList<StateChange>();
        for (Map.Entry<Integer, StateChange> entry : this.singletonUpdates.entrySet()) {
            allStateChanges.add(entry.getValue());
        }
        return allStateChanges;
    }

    public Set<StateChangeListener.StateType> stateTypes() {
        return TARGET_DATA_TYPES;
    }

    public <V> void singletonUpdateChange(int stateId, @NonNull V value) {
        Objects.requireNonNull(value, "value must not be null");
        StateChange stateChange = StateChange.newBuilder().stateId(stateId).singletonUpdate(new SingletonUpdateChange(BoundaryStateChangeListener.singletonUpdateChangeValueFor(value))).build();
        this.singletonUpdates.put(stateId, stateChange);
        if (stateId == V0590EntityIdSchema.ENTITY_COUNTS_STATE_ID) {
            this.updateEntityCountsMetrics((EntityCounts)value);
        }
    }

    private void updateEntityCountsMetrics(EntityCounts entityCounts) {
        Configuration configuration = this.configurationSupplier.get();
        long nodeCapacity = ((NodesConfig)configuration.getConfigData(NodesConfig.class)).maxNumber();
        StoreMetrics nodeMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.NODE, nodeCapacity);
        nodeMetrics.updateCount(entityCounts.numNodes());
        long topicCapacity = ((TopicsConfig)configuration.getConfigData(TopicsConfig.class)).maxNumber();
        StoreMetrics topicMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.TOPIC, topicCapacity);
        topicMetrics.updateCount(entityCounts.numTopics());
        ContractsConfig contractsConfig = (ContractsConfig)configuration.getConfigData(ContractsConfig.class);
        long maxSlotStorageCapacity = contractsConfig.maxKvPairsAggregate();
        StoreMetrics storageSlotsMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.SLOT_STORAGE, maxSlotStorageCapacity);
        storageSlotsMetrics.updateCount(entityCounts.numContractStorageSlots());
        long maxContractsCapacity = contractsConfig.maxNumber();
        StoreMetrics contractStoreMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.CONTRACT, maxContractsCapacity);
        contractStoreMetrics.updateCount(entityCounts.numContractBytecodes());
        long fileCapacity = ((FilesConfig)configuration.getConfigData(FilesConfig.class)).maxNumber();
        StoreMetrics fileMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.FILE, fileCapacity);
        fileMetrics.updateCount(entityCounts.numFiles());
        long scheduleCapacity = ((SchedulingConfig)configuration.getConfigData(SchedulingConfig.class)).maxNumber();
        StoreMetrics scheduleMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.SCHEDULE, scheduleCapacity);
        scheduleMetrics.updateCount(entityCounts.numSchedules());
        long accountsCapacity = ((AccountsConfig)configuration.getConfigData(AccountsConfig.class)).maxNumber();
        StoreMetrics accountMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.ACCOUNT, accountsCapacity);
        accountMetrics.updateCount(entityCounts.numAccounts());
        long airdropCapacity = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).maxAllowedPendingAirdrops();
        StoreMetrics airdropMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.AIRDROP, airdropCapacity);
        airdropMetrics.updateCount(entityCounts.numAirdrops());
        long nftsCapacity = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).nftsMaxAllowedMints();
        StoreMetrics nftsMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.NFT, nftsCapacity);
        nftsMetrics.updateCount(entityCounts.numNfts());
        long maxRels = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).maxAggregateRels();
        StoreMetrics tokenRelsMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.TOKEN_RELATION, maxRels);
        tokenRelsMetrics.updateCount(entityCounts.numTokenRelations());
        long tokenCapacity = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).maxNumber();
        StoreMetrics tokenMetrics = this.storeMetricsService.get(StoreMetricsService.StoreType.TOKEN, tokenCapacity);
        tokenMetrics.updateCount(entityCounts.numTokens());
    }

    @NonNull
    public static <V> OneOf<SingletonUpdateChange.NewValueOneOfType> singletonUpdateChangeValueFor(@NonNull V value) {
        V v = value;
        Objects.requireNonNull(v);
        V v2 = v;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockInfo.class, RosterState.class, CongestionLevelStarts.class, EntityNumber.class, ExchangeRateSet.class, NetworkStakingRewards.class, NodeRewards.class, NodePayments.class, ProtoBytes.class, ProtoString.class, RunningHashes.class, ThrottleUsageSnapshots.class, Timestamp.class, BlockStreamInfo.class, PlatformState.class, HintsConstruction.class, EntityCounts.class, HistoryProofConstruction.class, CRSState.class}, v2, n)) {
            case 0: {
                BlockInfo blockInfo = (BlockInfo)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.BLOCK_INFO_VALUE, (Object)blockInfo);
            }
            case 1: {
                RosterState rosterState = (RosterState)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.ROSTER_STATE_VALUE, (Object)rosterState);
            }
            case 2: {
                CongestionLevelStarts congestionLevelStarts = (CongestionLevelStarts)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.CONGESTION_LEVEL_STARTS_VALUE, (Object)congestionLevelStarts);
            }
            case 3: {
                EntityNumber entityNumber = (EntityNumber)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.ENTITY_NUMBER_VALUE, (Object)entityNumber.number());
            }
            case 4: {
                ExchangeRateSet exchangeRateSet = (ExchangeRateSet)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.EXCHANGE_RATE_SET_VALUE, (Object)exchangeRateSet);
            }
            case 5: {
                NetworkStakingRewards networkStakingRewards = (NetworkStakingRewards)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.NETWORK_STAKING_REWARDS_VALUE, (Object)networkStakingRewards);
            }
            case 6: {
                NodeRewards nodeRewards = (NodeRewards)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.NODE_REWARDS_VALUE, (Object)nodeRewards);
            }
            case 7: {
                NodePayments nodePayments = (NodePayments)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.NODE_PAYMENTS_VALUE, (Object)nodePayments);
            }
            case 8: {
                ProtoBytes protoBytes = (ProtoBytes)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.BYTES_VALUE, (Object)protoBytes.value());
            }
            case 9: {
                ProtoString protoString = (ProtoString)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.STRING_VALUE, (Object)protoString.value());
            }
            case 10: {
                RunningHashes runningHashes = (RunningHashes)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.RUNNING_HASHES_VALUE, (Object)runningHashes);
            }
            case 11: {
                ThrottleUsageSnapshots throttleUsageSnapshots = (ThrottleUsageSnapshots)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.THROTTLE_USAGE_SNAPSHOTS_VALUE, (Object)throttleUsageSnapshots);
            }
            case 12: {
                Timestamp timestamp = (Timestamp)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.TIMESTAMP_VALUE, (Object)timestamp);
            }
            case 13: {
                BlockStreamInfo blockStreamInfo = (BlockStreamInfo)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.BLOCK_STREAM_INFO_VALUE, (Object)blockStreamInfo);
            }
            case 14: {
                PlatformState platformState = (PlatformState)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.PLATFORM_STATE_VALUE, (Object)platformState);
            }
            case 15: {
                HintsConstruction hintsConstruction = (HintsConstruction)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.HINTS_CONSTRUCTION_VALUE, (Object)hintsConstruction);
            }
            case 16: {
                EntityCounts entityCounts = (EntityCounts)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.ENTITY_COUNTS_VALUE, (Object)entityCounts);
            }
            case 17: {
                HistoryProofConstruction historyProofConstruction = (HistoryProofConstruction)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.HISTORY_PROOF_CONSTRUCTION_VALUE, (Object)historyProofConstruction);
            }
            case 18: {
                CRSState crsState = (CRSState)v2;
                return new OneOf((Enum)SingletonUpdateChange.NewValueOneOfType.CRS_STATE_VALUE, (Object)crsState);
            }
        }
        throw new IllegalArgumentException("Unknown value type " + value.getClass().getName());
    }
}

