/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.node.app.service.file.impl.handlers.FileAppendHandler;
import com.hedera.node.app.service.file.impl.handlers.FileCreateHandler;
import com.hedera.node.app.service.file.impl.handlers.FileDeleteHandler;
import com.hedera.node.app.service.file.impl.handlers.FileGetContentsHandler;
import com.hedera.node.app.service.file.impl.handlers.FileGetInfoHandler;
import com.hedera.node.app.service.file.impl.handlers.FileSystemDeleteHandler;
import com.hedera.node.app.service.file.impl.handlers.FileSystemUndeleteHandler;
import com.hedera.node.app.service.file.impl.handlers.FileUpdateHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileHandlers {
    private final FileAppendHandler fileAppendHandler;
    private final FileCreateHandler fileCreateHandler;
    private final FileDeleteHandler fileDeleteHandler;
    private final FileGetContentsHandler fileGetContentsHandler;
    private final FileGetInfoHandler fileGetInfoHandler;
    private final FileSystemDeleteHandler fileSystemDeleteHandler;
    private final FileSystemUndeleteHandler fileSystemUndeleteHandler;
    private final FileUpdateHandler fileUpdateHandler;

    @Inject
    public FileHandlers(@NonNull FileAppendHandler fileAppendHandler, @NonNull FileCreateHandler fileCreateHandler, @NonNull FileDeleteHandler fileDeleteHandler, @NonNull FileGetContentsHandler fileGetContentsHandler, @NonNull FileGetInfoHandler fileGetInfoHandler, @NonNull FileSystemDeleteHandler fileSystemDeleteHandler, @NonNull FileSystemUndeleteHandler fileSystemUndeleteHandler, @NonNull FileUpdateHandler fileUpdateHandler) {
        this.fileAppendHandler = Objects.requireNonNull(fileAppendHandler, "fileAppendHandler must not be null");
        this.fileCreateHandler = Objects.requireNonNull(fileCreateHandler, "fileCreateHandler must not be null");
        this.fileDeleteHandler = Objects.requireNonNull(fileDeleteHandler, "fileDeleteHandler must not be null");
        this.fileGetContentsHandler = Objects.requireNonNull(fileGetContentsHandler, "fileGetContentsHandler must not be null");
        this.fileGetInfoHandler = Objects.requireNonNull(fileGetInfoHandler, "fileGetInfoHandler must not be null");
        this.fileSystemDeleteHandler = Objects.requireNonNull(fileSystemDeleteHandler, "fileSystemDeleteHandler must not be null");
        this.fileSystemUndeleteHandler = Objects.requireNonNull(fileSystemUndeleteHandler, "fileSystemUndeleteHandler must not be null");
        this.fileUpdateHandler = Objects.requireNonNull(fileUpdateHandler, "fileUpdateHandler must not be null");
    }

    public FileAppendHandler fileAppendHandler() {
        return this.fileAppendHandler;
    }

    public FileCreateHandler fileCreateHandler() {
        return this.fileCreateHandler;
    }

    public FileDeleteHandler fileDeleteHandler() {
        return this.fileDeleteHandler;
    }

    public FileGetContentsHandler fileGetContentsHandler() {
        return this.fileGetContentsHandler;
    }

    public FileGetInfoHandler fileGetInfoHandler() {
        return this.fileGetInfoHandler;
    }

    public FileSystemDeleteHandler fileSystemDeleteHandler() {
        return this.fileSystemDeleteHandler;
    }

    public FileSystemUndeleteHandler fileSystemUndeleteHandler() {
        return this.fileSystemUndeleteHandler;
    }

    public FileUpdateHandler fileUpdateHandler() {
        return this.fileUpdateHandler;
    }
}

