/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.HeaderNames;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.http.http2.Http2Headers;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ClientResponseImpl;
import java.net.URI;

class RedirectionProcessor {
    private RedirectionProcessor() {
    }

    static boolean redirectionStatusCode(Status status) {
        return status.family() == Status.Family.REDIRECTION;
    }

    static void checkRedirectHeaders(Http2Headers headerValues) {
        if (!headerValues.httpHeaders().contains(HeaderNames.LOCATION)) {
            throw new IllegalStateException("There is no " + String.valueOf(HeaderNames.LOCATION) + " header present in the response! It is not clear where to redirect.");
        }
    }

    static void checkRedirectHeaders(ClientResponseHeaders headerValues) {
        if (!headerValues.contains(HeaderNames.LOCATION)) {
            throw new IllegalStateException("There is no " + String.valueOf(HeaderNames.LOCATION) + " header present in the response! It is not clear where to redirect.");
        }
    }

    static Http2ClientResponseImpl invokeWithFollowRedirects(Http2ClientRequestImpl request, int initial, Object entity) {
        Http2ClientRequestImpl clientRequest = request;
        Object entityToBeSent = entity;
        for (int i = initial; i < request.maxRedirects(); ++i) {
            Http2ClientResponseImpl clientResponse = clientRequest.invokeEntity(entityToBeSent);
            if (!RedirectionProcessor.redirectionStatusCode(clientResponse.status())) {
                return clientResponse;
            }
            try (Http2ClientResponseImpl http2ClientResponseImpl = clientResponse;){
                if (!clientResponse.headers().contains(HeaderNames.LOCATION)) {
                    throw new IllegalStateException("There is no " + String.valueOf(HeaderNames.LOCATION) + " header present in the response! It is not clear where to redirect.");
                }
            }
            String redirectedUri = (String)clientResponse.headers().get(HeaderNames.LOCATION).get();
            URI newUri = URI.create(redirectedUri);
            ClientUri redirectUri = ClientUri.create((URI)newUri);
            if (newUri.getHost() == null) {
                ClientUri resolvedUri = clientRequest.resolvedUri();
                redirectUri.scheme(resolvedUri.scheme());
                redirectUri.host(resolvedUri.host());
                redirectUri.port(resolvedUri.port());
            }
            if (clientResponse.status() == Status.TEMPORARY_REDIRECT_307 || clientResponse.status() == Status.PERMANENT_REDIRECT_308) {
                clientRequest = new Http2ClientRequestImpl(clientRequest, clientRequest.method(), redirectUri, request.properties());
                continue;
            }
            entityToBeSent = BufferData.EMPTY_BYTES;
            clientRequest = new Http2ClientRequestImpl(clientRequest, Method.GET, redirectUri, request.properties());
        }
        throw new IllegalStateException("Maximum number of request redirections (" + request.maxRedirects() + ") reached.");
    }
}

