/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRoute;
import java.util.function.Predicate;

public class Http2Route
implements HttpRoute {
    private final Predicate<Method> methodPredicate;
    private final PathMatcher pathMatcher;
    private final Handler handler;

    private Http2Route(Predicate<Method> methodPredicate, PathMatcher pathMatcher, Handler handler) {
        this.methodPredicate = methodPredicate;
        this.pathMatcher = pathMatcher;
        this.handler = handler;
    }

    public static Http2Route route(Method method, String path, Handler handler) {
        return new Http2Route((Predicate<Method>)Method.predicate((Method[])new Method[]{method}), PathMatchers.create((String)path), handler);
    }

    public PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        if (!prologue.protocolVersion().equals("2.0")) {
            return PathMatchers.MatchResult.notAccepted();
        }
        if (!this.methodPredicate.test(prologue.method())) {
            return PathMatchers.MatchResult.notAccepted();
        }
        return this.pathMatcher.match(prologue.uriPath());
    }

    public Handler handler() {
        return this.handler;
    }

    public void beforeStart() {
        this.handler.beforeStart();
    }

    public void afterStop() {
        this.handler.afterStop();
    }
}

