/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.hyperledger.besu.nativelib.secp256k1.LibSecp256k1;

public final class EthSigsUtils {
    private EthSigsUtils() {
    }

    public static byte[] recoverAddressFromPrivateKey(@NonNull byte[] privateKeyBytes) {
        Objects.requireNonNull(privateKeyBytes);
        LibSecp256k1.secp256k1_pubkey pubKey = new LibSecp256k1.secp256k1_pubkey();
        int parseResult = LibSecp256k1.secp256k1_ec_pubkey_create((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)pubKey, (byte[])privateKeyBytes);
        if (parseResult == 1) {
            return EthSigsUtils.recoverAddressFromPubKey(pubKey);
        }
        return new byte[0];
    }

    public static byte[] recoverAddressFromPubKey(@NonNull byte[] pubKeyBytes) {
        Objects.requireNonNull(pubKeyBytes);
        LibSecp256k1.secp256k1_pubkey pubKey = new LibSecp256k1.secp256k1_pubkey();
        int parseResult = LibSecp256k1.secp256k1_ec_pubkey_parse((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)pubKey, (byte[])pubKeyBytes, (long)pubKeyBytes.length);
        if (parseResult == 1) {
            return EthSigsUtils.recoverAddressFromPubKey(pubKey);
        }
        return new byte[0];
    }

    public static Bytes recoverAddressFromPubKey(@NonNull Bytes pubKeyBytes) {
        Objects.requireNonNull(pubKeyBytes);
        return Bytes.wrap((byte[])EthSigsUtils.recoverAddressFromPubKey(pubKeyBytes.toByteArray()));
    }

    public static byte[] recoverAddressFromPubKey(@NonNull LibSecp256k1.secp256k1_pubkey pubKey) {
        Objects.requireNonNull(pubKey);
        ByteBuffer recoveredFullKey = ByteBuffer.allocate(65);
        LongByReference fullKeySize = new LongByReference((long)recoveredFullKey.limit());
        LibSecp256k1.secp256k1_ec_pubkey_serialize((PointerByReference)LibSecp256k1.CONTEXT, (ByteBuffer)recoveredFullKey, (LongByReference)fullKeySize, (LibSecp256k1.secp256k1_pubkey)pubKey, (int)2);
        recoveredFullKey.get();
        byte[] preHash = new byte[64];
        recoveredFullKey.get(preHash, 0, 64);
        byte[] keyHash = new Keccak.Digest256().digest(preHash);
        byte[] address = new byte[20];
        System.arraycopy(keyHash, 12, address, 0, 20);
        return address;
    }
}

