/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransactionResult;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCreateStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;

public record CallOutcome(@Deprecated @NonNull ContractFunctionResult result, @NonNull ResponseCodeEnum status, @Nullable ContractID recipientId, @Nullable List<ContractAction> actions, @Nullable List<EvmTransactionLog> logs, @Nullable List<ContractNonceInfo> changedNonceInfos, @Nullable List<ContractID> createdContractIds, @NonNull EvmTransactionResult txResult, @Nullable Long newSenderNonce, @Nullable Bytes createdEvmAddress, @Nullable TxStorageUsage txStorageUsage) {
    public CallOutcome {
        Objects.requireNonNull(result);
        Objects.requireNonNull(txResult);
        Objects.requireNonNull(status);
    }

    public boolean hasNewSenderNonce() {
        return this.newSenderNonce != null;
    }

    public long newSenderNonceOrThrow() {
        return Objects.requireNonNull(this.newSenderNonce);
    }

    public boolean hasTxStorageUsage() {
        return this.txStorageUsage != null;
    }

    @NonNull
    public TxStorageUsage txStorageUsageOrThrow() {
        return Objects.requireNonNull(this.txStorageUsage);
    }

    public boolean hasLogs() {
        return this.logs != null && !this.logs.isEmpty();
    }

    public boolean hasChangedNonces() {
        return this.changedNonceInfos != null && !this.changedNonceInfos.isEmpty();
    }

    public boolean hasCreatedContractIds() {
        return this.createdContractIds != null && !this.createdContractIds.isEmpty();
    }

    @NonNull
    public List<EvmTransactionLog> logsOrThrow() {
        return Objects.requireNonNull(this.logs);
    }

    @NonNull
    public List<ContractNonceInfo> changedNonceInfosOrThrow() {
        return Objects.requireNonNull(this.changedNonceInfos);
    }

    @NonNull
    public List<ContractID> createdContractIdsOrThrow() {
        return Objects.requireNonNull(this.createdContractIds);
    }

    public static CallOutcome fromResultsWithMaybeSidecars(@Deprecated @NonNull ContractFunctionResult result, @NonNull EvmTransactionResult txResult, @Nullable List<ContractNonceInfo> changedNonceInfos, @Nullable List<ContractID> createdContractIds, @Nullable Bytes evmAddress, @NonNull HederaEvmTransactionResult hevmResult) {
        return new CallOutcome(result, hevmResult.finalStatus(), hevmResult.recipientId(), hevmResult.actions(), hevmResult.evmLogs(), changedNonceInfos, createdContractIds, txResult, hevmResult.signerNonce(), evmAddress, hevmResult.txStorageUsage());
    }

    public static CallOutcome fromResultsWithoutSidecars(@NonNull ContractFunctionResult result, @NonNull EvmTransactionResult txResult, @Nullable List<ContractNonceInfo> updatedNonceInfos, @Nullable List<ContractID> createdContractIds, @Nullable Bytes evmAddress, @NonNull HederaEvmTransactionResult hevmResult) {
        return new CallOutcome(result, hevmResult.finalStatus(), hevmResult.recipientId(), null, hevmResult.evmLogs(), updatedNonceInfos, createdContractIds, txResult, hevmResult.signerNonce(), evmAddress, null);
    }

    public boolean isSuccess() {
        return this.status == ResponseCodeEnum.SUCCESS;
    }

    public void addCallDetailsTo(@NonNull ContractCallStreamBuilder streamBuilder, @NonNull HandleContext context) {
        Objects.requireNonNull(streamBuilder);
        Objects.requireNonNull(context);
        this.addCalledContractIfNotAborted(streamBuilder);
        streamBuilder.contractCallResult(this.result);
        streamBuilder.evmCallTransactionResult(this.txResult);
        streamBuilder.withCommonFieldsSetFrom(this, context);
    }

    public void addCalledContractIfNotAborted(@NonNull ContractCallStreamBuilder streamBuilder) {
        Objects.requireNonNull(streamBuilder);
        if (!this.callWasAborted()) {
            streamBuilder.contractID(this.recipientId);
        }
    }

    public void addCreateDetailsTo(@NonNull ContractCreateStreamBuilder streamBuilder, @NonNull HandleContext context) {
        Objects.requireNonNull(streamBuilder);
        Objects.requireNonNull(context);
        streamBuilder.contractCreateResult(this.result);
        streamBuilder.createdContractID(this.recipientIdIfCreated()).createdEvmAddress(this.createdEvmAddress).evmCreateTransactionResult(this.txResult).withCommonFieldsSetFrom(this, context);
    }

    @Nullable
    public ContractID recipientIdIfCreated() {
        return this.representsTopLevelCreation() ? this.txResult.contractIdOrThrow() : null;
    }

    private boolean representsTopLevelCreation() {
        return this.isSuccess() && this.createdEvmAddress != null;
    }

    private boolean callWasAborted() {
        return this.txResult.gasUsed() == 0L;
    }
}

