/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorized;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.node.app.service.contract.impl.annotations.ServicesV051;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isauthorized.IsAuthorizedCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IsAuthorizedTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod IS_AUTHORIZED = SystemContractMethod.declare("isAuthorized(address,bytes,bytes)", "(int64,bool)").withCategories(SystemContractMethod.Category.IS_AUTHORIZED);
    private static final int ADDRESS_ARG = 0;
    private static final int MESSAGE_ARG = 1;
    private static final int SIGNATURE_BLOB_ARG = 2;
    private final CustomGasCalculator customGasCalculator;

    @Inject
    public IsAuthorizedTranslator(@ServicesV051 @NonNull FeatureFlags featureFlags, @NonNull CustomGasCalculator customGasCalculator, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        Objects.requireNonNull(featureFlags, "featureFlags");
        this.customGasCalculator = Objects.requireNonNull(customGasCalculator);
        this.registerMethods(IS_AUTHORIZED);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        boolean callEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractAccountServiceIsAuthorizedEnabled();
        if (attempt.isSelectorIfConfigEnabled(callEnabled, IS_AUTHORIZED)) {
            return Optional.of(IS_AUTHORIZED);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        if (attempt.isSelector(IS_AUTHORIZED)) {
            Tuple call = IS_AUTHORIZED.decodeCall(attempt.inputBytes());
            Address address = (Address)call.get(0);
            byte[] message = (byte[])call.get(1);
            byte[] signatureBlob = (byte[])call.get(2);
            return new IsAuthorizedCall(attempt, address, message, signatureBlob, this.customGasCalculator);
        }
        return null;
    }
}

