/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.updatetokencustomfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.updatetokencustomfees.UpdateTokenCustomFeesDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UpdateTokenCustomFeesTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod UPDATE_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION = SystemContractMethod.declare("updateFungibleTokenCustomFees(address,(int64,address,bool,bool,address)[],(int64,int64,int64,int64,bool,address)[])", "(int)").withVariants(SystemContractMethod.Variant.FT, SystemContractMethod.Variant.WITH_CUSTOM_FEES).withCategories(SystemContractMethod.Category.UPDATE);
    public static final SystemContractMethod UPDATE_NON_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION = SystemContractMethod.declare("updateNonFungibleTokenCustomFees(address,(int64,address,bool,bool,address)[],(int64,int64,int64,address,bool,address)[])", "(int)").withVariants(SystemContractMethod.Variant.NFT, SystemContractMethod.Variant.WITH_CUSTOM_FEES).withCategories(SystemContractMethod.Category.UPDATE);
    private final UpdateTokenCustomFeesDecoder decoder;

    @Inject
    public UpdateTokenCustomFeesTranslator(@NonNull UpdateTokenCustomFeesDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        Objects.requireNonNull(decoder);
        this.decoder = decoder;
        this.registerMethods(UPDATE_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION, UPDATE_NON_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        if (!((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractUpdateCustomFeesEnabled()) {
            return Optional.empty();
        }
        return attempt.isMethod(UPDATE_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION, UPDATE_NON_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION);
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.UPDATE_TOKEN_CUSTOM_FEES, payerId);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, this.nominalBodyFor(attempt), UpdateTokenCustomFeesTranslator::gasRequirement);
    }

    private TransactionBody nominalBodyFor(@NonNull HtsCallAttempt attempt) {
        if (Arrays.equals(attempt.selector(), UPDATE_FUNGIBLE_TOKEN_CUSTOM_FEES_FUNCTION.selector())) {
            return this.decoder.decodeUpdateFungibleTokenCustomFees(attempt);
        }
        return this.decoder.decodeUpdateNonFungibleTokenCustomFees(attempt);
    }
}

