/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security;

import org.identityconnectors.common.security.Encryptor;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.SecurityUtil;

public final class GuardedByteArray {
    private static Encryptor _encryptor;
    private boolean _readOnly;
    private boolean _disposed;
    private byte[] _encryptedBytes;
    private String _base64SHA1Hash;

    public GuardedByteArray() {
        this(new byte[0]);
    }

    public GuardedByteArray(byte[] clearBytes) {
        this.encryptBytes(clearBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access(Accessor accessor) {
        this.checkNotDisposed();
        byte[] clearBytes = null;
        try {
            clearBytes = this.decryptBytes();
            accessor.access(clearBytes);
        }
        finally {
            SecurityUtil.clear(clearBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendByte(byte b) {
        this.checkNotDisposed();
        this.checkWriteable();
        byte[] clearBytes = null;
        byte[] clearBytes2 = null;
        try {
            clearBytes = this.decryptBytes();
            clearBytes2 = new byte[clearBytes.length + 1];
            System.arraycopy(clearBytes, 0, clearBytes2, 0, clearBytes.length);
            clearBytes2[clearBytes2.length - 1] = b;
            this.encryptBytes(clearBytes2);
        }
        catch (Throwable throwable) {
            SecurityUtil.clear(clearBytes);
            SecurityUtil.clear(clearBytes2);
            throw throwable;
        }
        SecurityUtil.clear(clearBytes);
        SecurityUtil.clear(clearBytes2);
    }

    public void dispose() {
        SecurityUtil.clear(this._encryptedBytes);
        this._disposed = true;
    }

    public boolean isReadOnly() {
        this.checkNotDisposed();
        return this._readOnly;
    }

    public void makeReadOnly() {
        this.checkNotDisposed();
        this._readOnly = true;
    }

    public GuardedByteArray copy() {
        this.checkNotDisposed();
        byte[] encryptedBytes2 = new byte[this._encryptedBytes.length];
        System.arraycopy(this._encryptedBytes, 0, encryptedBytes2, 0, this._encryptedBytes.length);
        GuardedByteArray rv = new GuardedByteArray();
        rv._encryptedBytes = encryptedBytes2;
        return rv;
    }

    public boolean verifyBase64SHA1Hash(String hash) {
        this.checkNotDisposed();
        return this._base64SHA1Hash.equals(hash);
    }

    private void checkWriteable() {
        if (this._readOnly) {
            throw new IllegalStateException("Byte array is read-only");
        }
    }

    private void checkNotDisposed() {
        if (this._disposed) {
            throw new IllegalStateException("Byte array is disposed");
        }
    }

    private static synchronized Encryptor getEncryptor() {
        if (_encryptor == null) {
            _encryptor = EncryptorFactory.getInstance().newRandomEncryptor();
        }
        return _encryptor;
    }

    static synchronized void setEncryptor(Encryptor encryptor) {
        _encryptor = encryptor;
    }

    private byte[] decryptBytes() {
        Encryptor encryptor = GuardedByteArray.getEncryptor();
        return encryptor.decrypt(this._encryptedBytes);
    }

    private void encryptBytes(byte[] bytes) {
        Encryptor encryptor = GuardedByteArray.getEncryptor();
        byte[] newBytes = encryptor.encrypt(bytes);
        SecurityUtil.clear(this._encryptedBytes);
        this._encryptedBytes = newBytes;
        this._base64SHA1Hash = SecurityUtil.computeBase64SHA1Hash(bytes);
    }

    public boolean equals(Object o) {
        if (o instanceof GuardedByteArray) {
            GuardedByteArray other = (GuardedByteArray)o;
            return this._base64SHA1Hash.equals(other._base64SHA1Hash);
        }
        return false;
    }

    public int hashCode() {
        return this._base64SHA1Hash.hashCode();
    }

    public static interface Accessor {
        public void access(byte[] var1);
    }
}

