/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.fluent;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.ModificationNotAllowedException;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.account.MutableAccount;

public class SimpleAccount
implements MutableAccount {
    private final Account parent;
    private boolean immutable = false;
    private Address address;
    private final Supplier<Hash> addressHash = Suppliers.memoize(() -> this.address == null ? Hash.ZERO : this.address.addressHash());
    private long nonce;
    private Wei balance;
    private Bytes code;
    private Supplier<Hash> codeHash = Suppliers.memoize(() -> this.code == null ? Hash.EMPTY : Hash.hash((Bytes)this.code));
    private final Map<UInt256, UInt256> storage = new HashMap<UInt256, UInt256>();

    public SimpleAccount(Address address, long nonce, Wei balance) {
        this(null, address, nonce, balance, Bytes.EMPTY);
    }

    public SimpleAccount(Account parent, Address address, long nonce, Wei balance, Bytes code) {
        this.parent = parent;
        this.address = address;
        this.nonce = nonce;
        this.balance = balance;
        this.code = code;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Hash getAddressHash() {
        return this.addressHash.get();
    }

    @Override
    public long getNonce() {
        return this.nonce;
    }

    @Override
    public Wei getBalance() {
        return this.balance;
    }

    @Override
    public Bytes getCode() {
        return this.code;
    }

    @Override
    public Hash getCodeHash() {
        return this.codeHash.get();
    }

    @Override
    public UInt256 getStorageValue(UInt256 key) {
        if (this.storage.containsKey(key)) {
            return this.storage.get(key);
        }
        return this.getOriginalStorageValue(key);
    }

    @Override
    public UInt256 getOriginalStorageValue(UInt256 key) {
        if (this.parent != null) {
            return this.parent.getStorageValue(key);
        }
        return UInt256.ZERO;
    }

    @Override
    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        throw new UnsupportedOperationException("Storage iteration not supported in simple account facade");
    }

    @Override
    public void setNonce(long value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.nonce = value;
    }

    @Override
    public void setBalance(Wei value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.balance = value;
    }

    @Override
    public void setCode(Bytes code) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.code = code;
        this.codeHash = Suppliers.memoize(() -> this.code == null ? Hash.EMPTY : Hash.hash((Bytes)this.code));
    }

    @Override
    public void setStorageValue(UInt256 key, UInt256 value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.storage.put(key, value);
    }

    @Override
    public void clearStorage() {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.storage.clear();
    }

    @Override
    public Map<UInt256, UInt256> getUpdatedStorage() {
        return this.storage;
    }

    @Override
    public boolean isStorageEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public void becomeImmutable() {
        this.immutable = true;
    }

    public boolean commit() {
        Account account = this.parent;
        if (account instanceof SimpleAccount) {
            SimpleAccount simpleAccount = (SimpleAccount)account;
            simpleAccount.balance = this.balance;
            simpleAccount.nonce = this.nonce;
            simpleAccount.storage.putAll(this.storage);
            return true;
        }
        return false;
    }
}

