/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class MLoadOperation
extends AbstractOperation {
    public MLoadOperation(GasCalculator gasCalculator) {
        super(81, "MLOAD", 1, 1, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long location = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().mLoadOperationGasCost(frame, location);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Bytes value = frame.readMutableMemory(location, 32L, true).copy();
        frame.pushStackItem(value);
        return new Operation.OperationResult(cost, null);
    }
}

