/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ContractError;
import com.esaulpaugh.headlong.abi.Event;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import java.io.InputStream;

public interface ABIObject {
    public TypeEnum getType();

    public String getName();

    public <T extends Tuple> TupleType<T> getInputs();

    public String getCanonicalSignature();

    default public String toJson(boolean pretty) {
        return ABIJSON.toJson(this, pretty, false);
    }

    default public boolean isFunction() {
        return false;
    }

    default public boolean isEvent() {
        return false;
    }

    default public boolean isContractError() {
        return false;
    }

    default public Function asFunction() {
        return (Function)this;
    }

    default public <X extends Tuple> Event<X> asEvent() {
        return (Event)this;
    }

    default public <X extends Tuple> ContractError<X> asContractError() {
        return (ContractError)this;
    }

    public static <T extends ABIObject> T fromJson(String json) {
        return ABIObject.fromJson(0, json);
    }

    public static <T extends ABIObject> T fromJson(int flags, String json) {
        return ABIJSON.parseABIObject(json, ABIJSON.ALL, Function.newDefaultDigest(), flags);
    }

    public static <T extends ABIObject> T fromJson(int flags, InputStream jsonStream) {
        return ABIJSON.parseABIObject(jsonStream, ABIJSON.ALL, Function.newDefaultDigest(), flags);
    }
}

