/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt64;
import org.apache.tuweni.units.bigints.UInt64Value;

public abstract class BaseUInt64Value<T extends UInt64Value<T>>
implements UInt64Value<T> {
    private final UInt64 value;
    private final Function<UInt64, T> ctor;

    protected BaseUInt64Value(UInt64 value, Function<UInt64, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = value;
        this.ctor = ctor;
    }

    protected BaseUInt64Value(long value, Function<UInt64, T> ctor) {
        Objects.requireNonNull(ctor);
        this.value = UInt64.valueOf(value);
        this.ctor = ctor;
    }

    protected BaseUInt64Value(BigInteger value, Function<UInt64, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = UInt64.valueOf(value);
        this.ctor = ctor;
    }

    protected T copy() {
        return (T)((UInt64Value)this.ctor.apply(this.value));
    }

    protected T zero() {
        return (T)((UInt64Value)this.ctor.apply(UInt64.ZERO));
    }

    @Override
    public T add(T value) {
        return this.add(value.toUInt64());
    }

    @Override
    public T add(UInt64 value) {
        if (value.isZero()) {
            return this.copy();
        }
        return (T)((UInt64Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T add(long value) {
        if (value == 0L) {
            return this.copy();
        }
        return (T)((UInt64Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T addMod(T value, UInt64 modulus) {
        return this.addMod(value.toUInt64(), modulus);
    }

    @Override
    public T addMod(UInt64 value, UInt64 modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, UInt64 modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, long modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T subtract(T value) {
        return this.subtract(value.toUInt64());
    }

    @Override
    public T subtract(UInt64 value) {
        if (value.isZero()) {
            return this.copy();
        }
        return (T)((UInt64Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T subtract(long value) {
        if (value == 0L) {
            return this.copy();
        }
        return (T)((UInt64Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T multiply(T value) {
        return this.multiply(value.toUInt64());
    }

    @Override
    public T multiply(UInt64 value) {
        if (this.isZero() || value.isZero()) {
            return this.zero();
        }
        if (value.equals(UInt64.ONE)) {
            return this.copy();
        }
        return (T)((UInt64Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiply(long value) {
        if (value == 0L || this.isZero()) {
            return this.zero();
        }
        if (value == 1L) {
            return this.copy();
        }
        return (T)((UInt64Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiplyMod(T value, UInt64 modulus) {
        return this.multiplyMod(value.toUInt64(), modulus);
    }

    @Override
    public T multiplyMod(UInt64 value, UInt64 modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(long value, UInt64 modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(long value, long modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T divide(T value) {
        return this.divide(value.toUInt64());
    }

    @Override
    public T divide(UInt64 value) {
        return (T)((UInt64Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T divide(long value) {
        return (T)((UInt64Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T pow(UInt64 exponent) {
        return (T)((UInt64Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T pow(long exponent) {
        return (T)((UInt64Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T mod(UInt64 modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public T mod(long modulus) {
        return (T)((UInt64Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public int compareTo(T other) {
        return this.compareTo(other.toUInt64());
    }

    @Override
    public int compareTo(UInt64 other) {
        return this.value.compareTo(other);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UInt64Value)) {
            return false;
        }
        UInt64Value other = (UInt64Value)obj;
        return this.value.equals(other.toUInt64());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public UInt64 toUInt64() {
        return this.value;
    }

    @Override
    public Bytes toBytes() {
        return this.value.toBytes();
    }

    @Override
    public Bytes toMinimalBytes() {
        return this.value.toMinimalBytes();
    }
}

