/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.datatypes.parameters.UnsignedLongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class StateOverride {
    private static final Logger LOG = LoggerFactory.getLogger(StateOverride.class);
    private final Optional<Wei> balance;
    private final Optional<Long> nonce;
    private final Optional<String> code;
    private final Optional<Map<String, String>> state;
    private final Optional<Map<String, String>> stateDiff;
    private final Optional<Address> movePrecompileToAddress;

    private StateOverride(Optional<Wei> balance, Optional<Long> nonce, Optional<String> code, Optional<Map<String, String>> state, Optional<Map<String, String>> stateDiff, Optional<Address> movePrecompileToAddress) {
        this.balance = balance;
        this.nonce = nonce;
        this.code = code;
        this.state = state;
        this.stateDiff = stateDiff;
        this.movePrecompileToAddress = movePrecompileToAddress;
    }

    public Optional<Wei> getBalance() {
        return this.balance;
    }

    public Optional<Long> getNonce() {
        return this.nonce;
    }

    public Optional<String> getCode() {
        return this.code;
    }

    public Optional<Map<String, String>> getState() {
        return this.state;
    }

    public Optional<Map<String, String>> getStateDiff() {
        return this.stateDiff;
    }

    public Optional<Address> getMovePrecompileToAddress() {
        return this.movePrecompileToAddress;
    }

    @JsonAnySetter
    public void withUnknownProperties(String key, Object value) {
        LOG.debug("unknown property - {} with value - {} and type - {} caught during serialization", new Object[]{key, value, value != null ? value.getClass() : "NULL"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateOverride stateOverride = (StateOverride)o;
        return this.balance.equals(stateOverride.balance) && this.nonce.equals(stateOverride.nonce) && this.code.equals(stateOverride.code) && this.state.equals(stateOverride.state) && this.stateDiff.equals(stateOverride.stateDiff);
    }

    public int hashCode() {
        return Objects.hash(this.balance, this.nonce, this.code, this.state, this.stateDiff);
    }

    public String toString() {
        return "StateOverride{balance=" + String.valueOf(this.balance) + ", nonce=" + String.valueOf(this.nonce) + ", code=" + String.valueOf(this.code) + ", state=" + String.valueOf(this.state) + ", stateDiff=" + String.valueOf(this.stateDiff) + ", movePrecompileToAddress=" + String.valueOf(this.movePrecompileToAddress) + "}";
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Builder {
        private Optional<Wei> balance = Optional.empty();
        private Optional<Long> nonce = Optional.empty();
        private Optional<String> code = Optional.empty();
        private Optional<Map<String, String>> state = Optional.empty();
        private Optional<Map<String, String>> stateDiff = Optional.empty();
        private Optional<Address> movePrecompileToAddress = Optional.empty();

        public Builder withBalance(Wei balance) {
            this.balance = Optional.ofNullable(balance);
            return this;
        }

        public Builder withNonce(UnsignedLongParameter nonce) {
            this.nonce = Optional.of(nonce.getValue());
            return this;
        }

        public Builder withCode(String code) {
            this.code = Optional.ofNullable(code);
            return this;
        }

        public Builder withState(Map<String, String> state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        public Builder withStateDiff(Map<String, String> stateDiff) {
            this.stateDiff = Optional.ofNullable(stateDiff);
            return this;
        }

        public Builder withMovePrecompileToAddress(Address newPrecompileAddress) {
            this.movePrecompileToAddress = Optional.ofNullable(newPrecompileAddress);
            return this;
        }

        public StateOverride build() {
            Preconditions.checkState((this.state.isEmpty() || this.stateDiff.isEmpty() ? 1 : 0) != 0, (Object)"Cannot set both state and stateDiff");
            return new StateOverride(this.balance, this.nonce, this.code, this.state, this.stateDiff, this.movePrecompileToAddress);
        }
    }
}

