/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage;

import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.UsageEstimate;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.SubType;
import com.hederahashgraph.api.proto.java.TransactionBody;

public interface EstimatorUtils {
    public static final long MAX_ENTITY_LIFETIME = 3153600000L;

    default public long baseBodyBytes(TransactionBody txn) {
        return 76L + (long)txn.getMemoBytes().size();
    }

    default public long nonDegenerateDiv(long dividend, int divisor) {
        return dividend == 0L ? 0L : Math.max(1L, dividend / (long)divisor);
    }

    default public long relativeLifetime(TransactionBody txn, long expiry) {
        long effectiveNow = txn.getTransactionID().getTransactionValidStart().getSeconds();
        return this.relativeLifetime(effectiveNow, expiry);
    }

    default public long relativeLifetime(long now, long expiry) {
        return expiry - now;
    }

    default public long changeInBsUsage(long oldB, long oldLifetimeSecs, long newB, long newLifetimeSecs) {
        oldLifetimeSecs = Math.min(3153600000L, oldLifetimeSecs);
        newLifetimeSecs = Math.min(3153600000L, newLifetimeSecs);
        newLifetimeSecs = Math.max(oldLifetimeSecs, newLifetimeSecs);
        long oldBs = Math.multiplyExact(oldB, oldLifetimeSecs);
        long newBs = Math.multiplyExact(newB, newLifetimeSecs);
        return Math.max(0L, newBs - oldBs);
    }

    public long baseNetworkRbs();

    public FeeData withDefaultTxnPartitioning(FeeComponents var1, SubType var2, long var3, int var5);

    public FeeData withDefaultQueryPartitioning(FeeComponents var1);

    public UsageEstimate baseEstimate(TransactionBody var1, SigUsage var2);
}

