/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.service.registry.EventDispatchException;
import io.helidon.service.registry.EventManager;
import io.helidon.service.registry.GeneratedService;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Service.Singleton
class EventManagerImpl
implements EventManager {
    private static final System.Logger LOGGER = System.getLogger(EventManager.class.getName());
    private final Supplier<List<GeneratedService.EventObserverRegistration>> registrations;
    private final Map<RegistrationKey, List<Consumer<?>>> listeners = new HashMap();
    private final Map<RegistrationKey, List<Consumer<?>>> asyncListeners = new HashMap();
    private final ReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private final ExecutorService executor;

    @Service.Inject
    EventManagerImpl(Supplier<List<GeneratedService.EventObserverRegistration>> registrations, @Service.NamedByType(value=EventManager.class) Optional<ExecutorService> executorService) {
        this.registrations = registrations;
        this.executor = executorService.orElseGet(() -> Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("inject-event-manager-", 0L).factory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void register(ResolvedType eventType, Consumer<T> eventConsumer, Set<Qualifier> qualifiers) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.computeIfAbsent(new RegistrationKey(eventType, qualifiers), k -> new ArrayList()).add(eventConsumer);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerAsync(ResolvedType eventType, Consumer<T> eventConsumer, Set<Qualifier> qualifiers) {
        this.listenersLock.writeLock().lock();
        try {
            this.asyncListeners.computeIfAbsent(new RegistrationKey(eventType, qualifiers), k -> new ArrayList()).add(eventConsumer);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(ResolvedType eventObjectType, Object eventObject, Set<Qualifier> qualifiers) {
        List<Consumer<?>> asyncConsumers;
        List<Consumer<?>> consumers;
        this.listenersLock.readLock().lock();
        try {
            consumers = this.listeners.get(new RegistrationKey(eventObjectType, qualifiers));
            asyncConsumers = this.asyncListeners.get(new RegistrationKey(eventObjectType, qualifiers));
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        if (asyncConsumers != null) {
            this.fireAndForget(asyncConsumers, eventObject);
        }
        if (consumers != null) {
            this.fire(consumers, eventObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CompletionStage<T> emitAsync(ResolvedType eventObjectType, T eventObject, Set<Qualifier> qualifiers) {
        List<Consumer<?>> asyncConsumers;
        List<Consumer<?>> consumers;
        this.listenersLock.readLock().lock();
        try {
            consumers = this.listeners.get(new RegistrationKey(eventObjectType, qualifiers));
            asyncConsumers = this.asyncListeners.get(new RegistrationKey(eventObjectType, qualifiers));
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        if (asyncConsumers != null) {
            this.fireAndForget(asyncConsumers, eventObject);
        }
        if (consumers != null) {
            return CompletableFuture.supplyAsync(() -> {
                this.fire(consumers, eventObject);
                return eventObject;
            }, this.executor);
        }
        return CompletableFuture.completedFuture(eventObject);
    }

    @Service.PostConstruct
    void init() {
        List<GeneratedService.EventObserverRegistration> registrationList = this.registrations.get();
        registrationList.forEach(reg -> reg.register(this));
    }

    private void fire(List<Consumer<?>> consumers, Object eventObject) {
        ArrayList<Exception> thrown = new ArrayList<Exception>();
        for (Consumer<?> consumer : consumers) {
            try {
                consumer.accept(eventObject);
            }
            catch (Exception e) {
                thrown.add(e);
            }
        }
        if (thrown.isEmpty()) {
            return;
        }
        EventDispatchException exception = new EventDispatchException("Event dispatching failed, see suppressed exceptions", (Throwable)thrown.getFirst());
        for (int i = 1; i < thrown.size(); ++i) {
            exception.addSuppressed((Throwable)thrown.get(i));
        }
        throw exception;
    }

    private void fireAndForget(List<Consumer<?>> asyncConsumers, Object eventObject) {
        for (Consumer<?> asyncConsumer : asyncConsumers) {
            this.executor.submit(() -> {
                try {
                    asyncConsumer.accept(eventObject);
                }
                catch (Exception e) {
                    LOGGER.log(System.Logger.Level.WARNING, "Asynchronous event dispatch failed.", (Throwable)e);
                }
            });
        }
    }

    private record RegistrationKey(ResolvedType eventObject, Set<Qualifier> qualifiers) {
    }
}

