/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.roster.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.app.roster.schemas.RosterTransplantSchema;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.VersionConfig;
import com.hedera.node.internal.network.Network;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.service.schemas.V0540RosterBaseSchema;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StartupNetworks;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.roster.WritableRosterStore;

public class V0540RosterSchema
extends Schema
implements RosterTransplantSchema {
    private static final Logger log = LogManager.getLogger(V0540RosterSchema.class);
    public static final String ROSTER_KEY = "ROSTERS";
    public static final String ROSTER_STATES_KEY = "ROSTER_STATE";
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(54).patch(0).build();
    private final V0540RosterBaseSchema baseSchema = new V0540RosterBaseSchema();
    private final BiConsumer<Roster, Roster> onAdopt;
    private final Predicate<Roster> canAdopt;
    private final Function<WritableStates, WritableRosterStore> rosterStoreFactory;
    @Deprecated
    private final Supplier<State> stateSupplier;
    private final PlatformStateFacade platformStateFacade;

    public V0540RosterSchema(@NonNull BiConsumer<Roster, Roster> onAdopt, @NonNull Predicate<Roster> canAdopt, @NonNull Function<WritableStates, WritableRosterStore> rosterStoreFactory, @NonNull Supplier<State> stateSupplier, @NonNull PlatformStateFacade platformStateFacade) {
        super(VERSION);
        this.onAdopt = Objects.requireNonNull(onAdopt);
        this.canAdopt = Objects.requireNonNull(canAdopt);
        this.rosterStoreFactory = Objects.requireNonNull(rosterStoreFactory);
        this.stateSupplier = Objects.requireNonNull(stateSupplier);
        this.platformStateFacade = platformStateFacade;
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return this.baseSchema.statesToCreate();
    }

    public void restart(@NonNull MigrationContext ctx) {
        Objects.requireNonNull(ctx);
        if (!RosterTransplantSchema.super.restart(ctx, this.onAdopt, this.rosterStoreFactory)) {
            StartupNetworks startupNetworks = ctx.startupNetworks();
            WritableRosterStore rosterStore = this.rosterStoreFactory.apply(ctx.newStates());
            long activeRoundNumber = ctx.roundNumber() + 1L;
            if (ctx.isGenesis()) {
                rosterStore.putActiveRoster(RosterUtils.rosterFrom((Network)startupNetworks.genesisNetworkOrThrow(ctx.platformConfig())), 0L);
            } else if (rosterStore.getActiveRoster() == null) {
                State state = this.stateSupplier.get();
                long round = this.platformStateFacade.roundOf(state);
                Roster previousRoster = Objects.requireNonNull(RosterRetriever.retrieveActive((State)state, (long)round));
                rosterStore.putActiveRoster(previousRoster, 0L);
                Roster currentRoster = RosterUtils.rosterFrom((Network)startupNetworks.migrationNetworkOrThrow(ctx.platformConfig()));
                rosterStore.putActiveRoster(currentRoster, activeRoundNumber);
            } else if (ctx.isUpgrade(((VersionConfig)ctx.appConfig().getConfigData(VersionConfig.class)).servicesVersion().copyBuilder().build("" + ((HederaConfig)ctx.appConfig().getConfigData(HederaConfig.class)).configVersion()).build())) {
                Roster candidateRoster = rosterStore.getCandidateRoster();
                if (candidateRoster == null) {
                    log.info("No candidate roster to adopt in round {}", (Object)activeRoundNumber);
                } else if (this.canAdopt.test(candidateRoster)) {
                    log.info("Adopting candidate roster in round {}", (Object)activeRoundNumber);
                    this.onAdopt.accept(Objects.requireNonNull(rosterStore.getActiveRoster()), candidateRoster);
                    rosterStore.adoptCandidateRoster(activeRoundNumber);
                } else {
                    log.info("Rejecting candidate roster in round {}", (Object)activeRoundNumber);
                }
            }
        }
    }
}

