/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.DateTime;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class SetCookie {
    private static final String PARAM_SEPARATOR = "; ";
    private final String name;
    private final String value;
    private final ZonedDateTime expires;
    private final Duration maxAge;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final SameSite sameSite;

    private SetCookie(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.expires = builder.expires;
        this.maxAge = builder.maxAge;
        this.domain = builder.domain;
        this.path = builder.path;
        this.secure = builder.secure;
        this.httpOnly = builder.httpOnly;
        this.sameSite = builder.sameSite;
    }

    public static Builder builder(String name, String value) {
        return new Builder(name, value);
    }

    public static Builder builder(SetCookie setCookie) {
        return new Builder(setCookie);
    }

    public static SetCookie parse(String setCookie) {
        String name;
        Objects.requireNonNull(setCookie);
        String[] cookieParts = setCookie.split(PARAM_SEPARATOR);
        String nameAndValue = cookieParts[0];
        int equalsIndex = nameAndValue.indexOf(61);
        String string = name = equalsIndex == -1 ? nameAndValue : nameAndValue.substring(0, equalsIndex);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Cookie name cannot be empty");
        }
        String value = equalsIndex == -1 ? "" : nameAndValue.substring(equalsIndex + 1);
        Builder builder = SetCookie.builder(name, value);
        block18: for (int i = 1; i < cookieParts.length; ++i) {
            String partValue;
            String partName;
            String cookiePart = cookieParts[i];
            equalsIndex = cookiePart.indexOf(61);
            if (equalsIndex > -1) {
                partName = cookiePart.substring(0, equalsIndex);
                partValue = cookiePart.substring(equalsIndex + 1);
            } else {
                partName = cookiePart;
                partValue = null;
            }
            switch (partName.toLowerCase()) {
                case "expires": {
                    SetCookie.hasValue(partName, partValue);
                    builder.expires(DateTime.parse(partValue));
                    continue block18;
                }
                case "max-age": {
                    SetCookie.hasValue(partName, partValue);
                    builder.maxAge(Duration.ofSeconds(Long.parseLong(partValue)));
                    continue block18;
                }
                case "domain": {
                    SetCookie.hasValue(partName, partValue);
                    builder.domain(partValue);
                    continue block18;
                }
                case "path": {
                    SetCookie.hasValue(partName, partValue);
                    builder.path(partValue);
                    continue block18;
                }
                case "secure": {
                    SetCookie.hasNoValue(partName, partValue);
                    builder.secure(true);
                    continue block18;
                }
                case "httponly": {
                    SetCookie.hasNoValue(partName, partValue);
                    builder.httpOnly(true);
                    continue block18;
                }
                case "samesite": {
                    SetCookie.hasValue(partName, partValue);
                    builder.sameSite(SameSite.valueOf(partValue.toUpperCase(Locale.ROOT)));
                    continue block18;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected Set-Cookie part: " + partName);
                }
            }
        }
        return builder.build();
    }

    public static SetCookie create(String name, String value) {
        return SetCookie.builder(name, value).build();
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Optional<ZonedDateTime> expires() {
        return Optional.ofNullable(this.expires);
    }

    public Optional<Duration> maxAge() {
        return Optional.ofNullable(this.maxAge);
    }

    public Optional<String> domain() {
        return Optional.ofNullable(this.domain);
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public Optional<SameSite> sameSite() {
        return Optional.ofNullable(this.sameSite);
    }

    public String text() {
        return this.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append('=').append(this.value);
        if (this.expires != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Expires=");
            result.append(this.expires.format(DateTime.RFC_1123_DATE_TIME));
        }
        if (this.maxAge != null && !this.maxAge.isNegative() && !this.maxAge.isZero()) {
            result.append(PARAM_SEPARATOR);
            result.append("Max-Age=");
            result.append(this.maxAge.getSeconds());
        }
        if (this.domain != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Domain=");
            result.append(this.domain);
        }
        if (this.path != null) {
            result.append(PARAM_SEPARATOR);
            result.append("Path=");
            result.append(this.path);
        }
        if (this.secure) {
            result.append(PARAM_SEPARATOR);
            result.append("Secure");
        }
        if (this.httpOnly) {
            result.append(PARAM_SEPARATOR);
            result.append("HttpOnly");
        }
        if (this.sameSite != null) {
            result.append(PARAM_SEPARATOR);
            result.append("SameSite=");
            result.append(this.sameSite.text());
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetCookie)) {
            return false;
        }
        SetCookie setCookie = (SetCookie)o;
        return Objects.equals(this.name, setCookie.name) && Objects.equals(this.domain, setCookie.domain) && Objects.equals(this.path, setCookie.path);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.domain, this.path);
    }

    private static void hasNoValue(String partName, String partValue) {
        if (partValue != null) {
            throw new IllegalArgumentException("Set-Cookie parameter " + partName + " has to have no value!");
        }
    }

    private static void hasValue(String partName, String partValue) {
        if (partValue == null) {
            throw new IllegalArgumentException("Set-Cookie parameter " + partName + " has to have a value!");
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, SetCookie> {
        private final String name;
        private final String value;
        private ZonedDateTime expires;
        private Duration maxAge;
        private String domain;
        private String path;
        private boolean secure = false;
        private boolean httpOnly = false;
        private SameSite sameSite;

        private Builder(String name, String value) {
            Objects.requireNonNull(name, "Parameter 'name' is null!");
            this.name = name;
            this.value = value;
        }

        private Builder(SetCookie other) {
            Objects.requireNonNull(other);
            this.name = other.name;
            this.value = other.value;
            this.expires = other.expires;
            this.maxAge = other.maxAge;
            this.domain = other.domain;
            this.path = other.path;
            this.secure = other.secure;
            this.httpOnly = other.httpOnly;
            this.sameSite = other.sameSite;
        }

        public SetCookie build() {
            return new SetCookie(this);
        }

        public Builder expires(ZonedDateTime expires) {
            this.expires = expires;
            return this;
        }

        public Builder expires(Instant expires) {
            this.expires = expires == null ? null : ZonedDateTime.ofInstant(expires, ZoneId.systemDefault());
            return this;
        }

        public Builder maxAge(Duration maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder domainAndPath(URI domainAndPath) {
            if (domainAndPath == null) {
                this.domain = null;
                this.path = null;
            } else {
                this.domain = domainAndPath.getHost();
                this.path = domainAndPath.getPath();
            }
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public Builder sameSite(SameSite sameSite) {
            this.sameSite = sameSite;
            return this;
        }
    }

    public static enum SameSite {
        LAX("Lax"),
        STRICT("Strict"),
        NONE("None");

        private final String text;

        private SameSite(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }
}

