/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features;

import io.helidon.common.features.api.HelidonFlavor;
import java.util.Arrays;
import java.util.Objects;

final class FeatureDescriptor
implements Comparable<FeatureDescriptor> {
    private final HelidonFlavor[] flavors;
    private final HelidonFlavor[] notFlavors;
    private final String name;
    private final String since;
    private final String[] path;
    private final String description;
    private final boolean nativeSupported;
    private final String nativeDescription;
    private final boolean preview;
    private final boolean incubating;
    private final String module;
    private final boolean deprecated;
    private final String deprecatedSince;

    private FeatureDescriptor(Builder builder) {
        this.flavors = builder.flavors;
        this.notFlavors = builder.notFlavors;
        this.name = builder.name;
        this.since = builder.since;
        this.module = builder.module;
        this.path = builder.path;
        this.description = builder.description;
        this.nativeSupported = builder.nativeSupported;
        this.nativeDescription = builder.nativeDescription;
        this.preview = builder.preview;
        this.incubating = builder.incubating;
        this.deprecated = builder.deprecated;
        this.deprecatedSince = builder.deprecatedSince;
    }

    static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.flavors);
        result = 31 * result + Arrays.hashCode(this.path);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureDescriptor that = (FeatureDescriptor)o;
        return Arrays.equals(this.flavors, that.flavors) && this.name.equals(that.name) && Arrays.equals(this.path, that.path);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(FeatureDescriptor o) {
        for (int i = 0; i < this.path.length && i < o.path.length; ++i) {
            int result = this.path[i].compareTo(o.path[i]);
            if (result == 0) continue;
            return result;
        }
        return this.path.length - o.path.length;
    }

    String module() {
        return this.module;
    }

    HelidonFlavor[] flavors() {
        return this.flavors;
    }

    HelidonFlavor[] notFlavors() {
        return this.notFlavors;
    }

    boolean not(HelidonFlavor flavor) {
        for (HelidonFlavor notFlavor : this.notFlavors) {
            if (flavor != notFlavor) continue;
            return true;
        }
        return false;
    }

    String name() {
        return this.name;
    }

    String[] path() {
        return this.path;
    }

    String description() {
        return this.description;
    }

    boolean nativeSupported() {
        return this.nativeSupported;
    }

    String nativeDescription() {
        return this.nativeDescription == null ? "" : this.nativeDescription;
    }

    String stringPath() {
        return String.join((CharSequence)"/", this.path());
    }

    boolean preview() {
        return this.preview;
    }

    String since() {
        return this.since;
    }

    boolean incubating() {
        return this.incubating;
    }

    boolean deprecated() {
        return this.deprecated;
    }

    String deprecatedSince() {
        return this.deprecatedSince;
    }

    boolean hasFlavor(HelidonFlavor expected) {
        for (HelidonFlavor flavor : this.flavors) {
            if (flavor != expected) continue;
            return true;
        }
        return false;
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, FeatureDescriptor> {
        private String module;
        private HelidonFlavor[] flavors;
        private HelidonFlavor[] notFlavors;
        private String name;
        private String since;
        private String[] path;
        private String description = null;
        private boolean nativeSupported = true;
        private String nativeDescription = null;
        private boolean incubating;
        private boolean preview;
        private boolean deprecated;
        private String deprecatedSince;

        private Builder() {
        }

        public FeatureDescriptor build() {
            return new FeatureDescriptor(this);
        }

        Builder module(String module) {
            this.module = module;
            return this;
        }

        Builder since(String version) {
            this.since = version;
            return this;
        }

        Builder preview(boolean preview) {
            this.preview = preview;
            return this;
        }

        Builder deprecated(boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        Builder deprecatedSince(String version) {
            this.deprecatedSince = version;
            return this;
        }

        Builder name(String name) {
            if (name == null || name.isEmpty()) {
                return this;
            }
            this.name = name;
            return this;
        }

        Builder path(String path) {
            if (path == null || path.isEmpty()) {
                return this;
            }
            this.path = new String[]{path};
            return this;
        }

        Builder description(String description) {
            if (description == null || description.isEmpty()) {
                return this;
            }
            this.description = description;
            return this;
        }

        Builder nativeSupported(boolean nativeSupported) {
            this.nativeSupported = nativeSupported;
            return this;
        }

        Builder nativeDescription(String description) {
            if (description == null || description.isEmpty()) {
                return this;
            }
            this.nativeDescription = description;
            return this;
        }

        Builder flavor(HelidonFlavor ... flavors) {
            this.flavors = flavors;
            return this;
        }

        Builder notFlavor(HelidonFlavor ... flavors) {
            this.notFlavors = flavors;
            return this;
        }

        Builder path(String ... path) {
            if (path.length == 0) {
                throw new IllegalArgumentException("Path must have at least one element");
            }
            this.path = path;
            return this;
        }

        Builder incubating(boolean incubating) {
            this.incubating = incubating;
            return this;
        }
    }
}

