/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.api;

import io.helidon.common.tls.Tls;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.spi.DnsResolver;
import java.time.Duration;
import java.util.Objects;

public final class ConnectionKey {
    private final String scheme;
    private final String host;
    private final int port;
    private final Tls tls;
    private final DnsResolver dnsResolver;
    private final DnsAddressLookup dnsAddressLookup;
    private final Proxy proxy;
    private final Duration readTimeout;

    @Deprecated(forRemoval=true, since="4.2.4")
    public ConnectionKey(String scheme, String host, int port, Duration readTimeout, Tls tls, DnsResolver dnsResolver, DnsAddressLookup dnsAddressLookup, Proxy proxy) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.readTimeout = readTimeout;
        this.tls = tls;
        this.dnsResolver = dnsResolver;
        this.dnsAddressLookup = dnsAddressLookup;
        this.proxy = proxy;
    }

    public static ConnectionKey create(String scheme, String host, int port, Tls tls, DnsResolver dnsResolver, DnsAddressLookup dnsAddressLookup, Proxy proxy) {
        return new ConnectionKey(scheme, host, port, Duration.ZERO, tls, dnsResolver, dnsAddressLookup, proxy);
    }

    public String scheme() {
        return this.scheme;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    @Deprecated(forRemoval=true, since="4.2.4")
    public Duration readTimeout() {
        return this.readTimeout;
    }

    public Tls tls() {
        return this.tls;
    }

    public DnsResolver dnsResolver() {
        return this.dnsResolver;
    }

    public DnsAddressLookup dnsAddressLookup() {
        return this.dnsAddressLookup;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConnectionKey that = (ConnectionKey)obj;
        return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && this.port == that.port && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.tls, that.tls) && Objects.equals(this.dnsResolver, that.dnsResolver) && Objects.equals((Object)this.dnsAddressLookup, (Object)that.dnsAddressLookup) && Objects.equals(this.proxy, that.proxy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.scheme, this.host, this.port, this.readTimeout, this.tls, this.dnsResolver, this.dnsAddressLookup, this.proxy});
    }

    public String toString() {
        return "ConnectionKey[scheme=" + this.scheme + ", host=" + this.host + ", port=" + this.port + ", readTimeout=" + String.valueOf(this.readTimeout) + ", tls=" + String.valueOf(this.tls) + ", dnsResolver=" + String.valueOf(this.dnsResolver) + ", dnsAddressLookup=" + String.valueOf((Object)this.dnsAddressLookup) + ", proxy=" + String.valueOf(this.proxy) + "]";
    }
}

