/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.ABIParser;
import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.ContractError;
import com.esaulpaugh.headlong.abi.Event;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import com.esaulpaugh.headlong.abi.TypeFactory;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public final class ABIJSON {
    static final EnumSet<TypeEnum> _ALL = EnumSet.allOf(TypeEnum.class);
    public static final Set<TypeEnum> ALL = Collections.unmodifiableSet(_ALL);
    public static final Set<TypeEnum> FUNCTIONS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.FUNCTION, TypeEnum.RECEIVE, TypeEnum.FALLBACK, TypeEnum.CONSTRUCTOR));
    public static final Set<TypeEnum> NORMAL_FUNCTIONS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.FUNCTION));
    public static final Set<TypeEnum> EVENTS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.EVENT));
    public static final Set<TypeEnum> ERRORS = Collections.unmodifiableSet(EnumSet.of(TypeEnum.ERROR));
    private static final String NAME = "name";
    private static final String TYPE = "type";
    static final String FUNCTION = "function";
    static final String RECEIVE = "receive";
    static final String FALLBACK = "fallback";
    static final String CONSTRUCTOR = "constructor";
    static final String EVENT = "event";
    static final String ERROR = "error";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String TUPLE = "tuple";
    private static final String COMPONENTS = "components";
    private static final String ANONYMOUS = "anonymous";
    private static final String INDEXED = "indexed";
    private static final String STATE_MUTABILITY = "stateMutability";
    static final String PAYABLE = "payable";
    private static final String INTERNAL_TYPE = "internalType";
    private static final int STRICTNESS;

    private ABIJSON() {
    }

    public static List<Function> parseNormalFunctions(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, NORMAL_FUNCTIONS);
    }

    public static List<Function> parseFunctions(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, FUNCTIONS);
    }

    public static List<Event<Tuple>> parseEvents(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, EVENTS);
    }

    public static List<ContractError<Tuple>> parseErrors(String arrayJson) {
        return ABIJSON.parseElements(arrayJson, ERRORS);
    }

    private static <T extends ABIObject> List<T> parseElements(String arrayJson, Set<TypeEnum> types) {
        return new ABIParser(0, types).parse(arrayJson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String optimize(String json) {
        try (JsonReader reader = ABIJSON.reader(json);){
            JsonToken token = reader.peek();
            if (token == JsonToken.BEGIN_OBJECT) {
                String string = ABIJSON.toJson(ABIObject.fromJson(json), false, true);
                return string;
            }
            if (token != JsonToken.BEGIN_ARRAY) throw new IllegalArgumentException("unexpected token: " + token);
            String string = ABIJSON.optimize(new ABIParser().parse(json));
            return string;
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    public static <T extends ABIObject> String optimize(List<T> elements) {
        return ABIJSON.encode(true, elements);
    }

    public static <T extends ABIObject> String encode(List<T> elements) {
        return ABIJSON.encode(false, elements);
    }

    private static <T extends ABIObject> String encode(boolean minify, List<T> elements) {
        NonSyncWriter stringOut = new NonSyncWriter(2048);
        try (JsonWriter out = new JsonWriter((Writer)stringOut);){
            out.setIndent(minify ? "" : "  ");
            out.beginArray();
            for (ABIObject e : elements) {
                ABIJSON.writeObject(e, out, minify);
            }
            out.endArray();
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
        return ((Object)stringOut).toString();
    }

    static String toJson(ABIObject o, boolean pretty, boolean minify) {
        NonSyncWriter stringOut = new NonSyncWriter(pretty ? 512 : 256);
        try (JsonWriter out = new JsonWriter((Writer)stringOut);){
            if (pretty) {
                out.setIndent("  ");
            }
            ABIJSON.writeObject(o, out, minify);
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
        return ((Object)stringOut).toString();
    }

    private static void writeObject(ABIObject o, JsonWriter out, boolean minify) throws IOException {
        out.beginObject();
        if (o.isFunction()) {
            String stateMutability;
            Function f = o.asFunction();
            TypeEnum t = o.getType();
            ABIJSON.type(out, t.toString());
            if (t != TypeEnum.FALLBACK) {
                ABIJSON.name(out, o.getName());
                if (t != TypeEnum.RECEIVE) {
                    ABIJSON.tupleType(out, INPUTS, o.getInputs(), null, minify);
                    if (t != TypeEnum.CONSTRUCTOR) {
                        ABIJSON.tupleType(out, OUTPUTS, f.getOutputs(), null, minify);
                    }
                }
            }
            if ((stateMutability = f.getStateMutability()) != null) {
                out.name(STATE_MUTABILITY).value(stateMutability);
            }
        } else if (o.isEvent()) {
            Event e = o.asEvent();
            ABIJSON.type(out, EVENT);
            ABIJSON.name(out, o.getName());
            ABIJSON.tupleType(out, INPUTS, o.getInputs(), e.getIndexManifest(), minify);
            if (!minify || e.isAnonymous()) {
                out.name(ANONYMOUS).value(e.isAnonymous());
            }
        } else {
            ABIJSON.type(out, ERROR);
            ABIJSON.name(out, o.getName());
            ABIJSON.tupleType(out, INPUTS, o.getInputs(), null, minify);
        }
        out.endObject();
    }

    private static void type(JsonWriter out, String type) throws IOException {
        out.name(TYPE).value(type);
    }

    private static void name(JsonWriter out, String name) throws IOException {
        if (name != null) {
            out.name(NAME).value(name);
        }
    }

    private static void tupleType(JsonWriter out, String name, TupleType<?> tupleType, boolean[] indexedManifest, boolean minify) throws IOException {
        if (minify && tupleType.isEmpty()) {
            return;
        }
        out.name(name).beginArray();
        for (int i = 0; i < tupleType.elementTypes.length; ++i) {
            String internalType;
            out.beginObject();
            if (tupleType.elementInternalTypes != null && (internalType = tupleType.elementInternalTypes[i]) != null) {
                out.name(INTERNAL_TYPE).value(internalType);
            }
            if (tupleType.elementNames != null) {
                ABIJSON.name(out, tupleType.elementNames[i]);
            }
            ABIType<?> e = tupleType.elementTypes[i];
            String type = e.canonicalType;
            if (type.charAt(0) == '(') {
                ABIJSON.type(out, TUPLE + type.substring(type.lastIndexOf(41) + 1));
                ABIJSON.tupleType(out, COMPONENTS, (TupleType)ArrayType.baseType(e), null, minify);
            } else {
                ABIJSON.type(out, type);
            }
            if (indexedManifest != null) {
                out.name(INDEXED).value(indexedManifest[i]);
            }
            out.endObject();
        }
        out.endArray();
    }

    static <T extends ABIObject> T parseABIObject(String json, Set<TypeEnum> types, MessageDigest digest, int flags) {
        return ABIJSON.parseABIObjectAndCloseReader(ABIJSON.reader(json), types, digest, flags);
    }

    static <T extends ABIObject> T parseABIObject(InputStream is, Set<TypeEnum> types, MessageDigest digest, int flags) {
        return ABIJSON.parseABIObjectAndCloseReader(ABIJSON.reader(is), types, digest, flags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T extends ABIObject> T parseABIObjectAndCloseReader(JsonReader reader, Set<TypeEnum> types, MessageDigest digest, int flags) {
        try (JsonReader ignored = reader;){
            T obj = ABIJSON.tryParseStreaming(reader, types, digest, flags);
            if (obj == null) throw new IllegalArgumentException("unexpected ABI object type");
            T t = obj;
            return t;
        }
        catch (IOException io) {
            throw new IllegalStateException(io);
        }
    }

    static <T extends ABIObject> T tryParseStreaming(JsonReader reader, Set<TypeEnum> types, MessageDigest digest, int flags) throws IOException {
        reader.beginObject();
        TypeEnum t = null;
        String name = null;
        TupleType<Object> inputs = null;
        TupleType<?> outputs = null;
        String stateMutability = null;
        Boolean anonymous = null;
        block21: do {
            switch (reader.nextName()) {
                case "type": {
                    ABIJSON.requireNull(t, TYPE);
                    t = TypeEnum.parse(reader.nextString());
                    if (types.contains((Object)t)) continue block21;
                    while (reader.peek() != JsonToken.END_OBJECT) {
                        reader.skipValue();
                    }
                    reader.endObject();
                    return null;
                }
                case "name": {
                    ABIJSON.requireNull(name, NAME);
                    name = reader.nextString();
                    break;
                }
                case "inputs": {
                    ABIJSON.requireNull(inputs, INPUTS);
                    inputs = ABIJSON.parseTupleType(reader, flags);
                    break;
                }
                case "outputs": {
                    ABIJSON.requireNull(outputs, OUTPUTS);
                    outputs = ABIJSON.parseTupleType(reader, flags);
                    break;
                }
                case "stateMutability": {
                    ABIJSON.requireNull(stateMutability, STATE_MUTABILITY);
                    stateMutability = reader.nextString();
                    break;
                }
                case "anonymous": {
                    ABIJSON.requireNull(anonymous, ANONYMOUS);
                    anonymous = reader.nextBoolean();
                    break;
                }
                default: {
                    reader.skipValue();
                }
            }
        } while (reader.peek() != JsonToken.END_OBJECT);
        reader.endObject();
        if (t == null && !types.contains((Object)(t = TypeEnum.FUNCTION))) {
            return null;
        }
        if (inputs == null) {
            inputs = TupleType.empty(flags);
        }
        switch (t.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return (T)new Function(t, name, inputs, outputs != null ? outputs : TupleType.empty(flags), stateMutability, digest);
            }
            case 4: {
                return (T)new Event(name, anonymous == Boolean.TRUE, inputs, inputs.indexed);
            }
            case 5: {
                return (T)new ContractError(name, inputs);
            }
        }
        throw new AssertionError();
    }

    private static void requireNull(Object val, String key) {
        if (val != null) {
            throw new IllegalStateException("duplicate field: " + key);
        }
    }

    private static TupleType<?> parseTupleType(JsonReader reader, int flags) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return TupleType.empty(flags);
        }
        reader.beginArray();
        if (reader.peek() == JsonToken.END_ARRAY) {
            reader.endArray();
            return TupleType.empty(flags);
        }
        StringBuilder canonicalType = TupleType.newTypeBuilder();
        ABIType[] elements = new ABIType[8];
        String[] names = new String[8];
        String[] internalTypes = new String[8];
        boolean[] indexedManifest = new boolean[8];
        boolean dynamic = false;
        int i = 0;
        while (true) {
            String type = null;
            TupleType<?> components = null;
            String internalType = null;
            Boolean indexed = null;
            reader.beginObject();
            block15: while (reader.peek() != JsonToken.END_OBJECT) {
                switch (reader.nextName()) {
                    case "type": {
                        ABIJSON.requireNull(type, TYPE);
                        type = reader.nextString();
                        continue block15;
                    }
                    case "components": {
                        ABIJSON.requireNull(components, COMPONENTS);
                        components = ABIJSON.parseTupleType(reader, flags);
                        continue block15;
                    }
                    case "name": {
                        ABIJSON.requireNull(names[i], NAME);
                        names[i] = reader.nextString();
                        continue block15;
                    }
                    case "internalType": {
                        ABIJSON.requireNull(internalType, INTERNAL_TYPE);
                        internalType = reader.nextString();
                        continue block15;
                    }
                    case "indexed": {
                        ABIJSON.requireNull(indexed, INDEXED);
                        indexed = reader.nextBoolean();
                        continue block15;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            ABIType<?> e = ABIJSON.resolveElement(type, components, flags, i);
            canonicalType.append(e.canonicalType);
            dynamic |= e.dynamic;
            elements[i] = e;
            if (internalType != null) {
                String string = internalTypes[i] = internalType.equals(e.canonicalType) ? e.canonicalType : internalType;
            }
            if (indexed == Boolean.TRUE) {
                indexedManifest[i] = true;
            }
            ++i;
            if (reader.peek() == JsonToken.END_ARRAY) {
                reader.endArray();
                return new TupleType(canonicalType.append(')').toString(), dynamic, Arrays.copyOf(elements, i), Arrays.copyOf(names, i), Arrays.copyOf(internalTypes, i), Arrays.copyOf(indexedManifest, i), flags);
            }
            if (i == elements.length) {
                int newLen = i << 1;
                elements = Arrays.copyOf(elements, newLen);
                names = Arrays.copyOf(names, newLen);
                internalTypes = Arrays.copyOf(internalTypes, newLen);
                indexedManifest = Arrays.copyOf(indexedManifest, newLen);
            }
            canonicalType.append(',');
        }
    }

    private static ABIType<?> resolveElement(String type, TupleType<?> components, int flags, int i) {
        if (type == null || type.charAt(0) == '(') {
            throw new IllegalArgumentException("bad type at tuple index " + i);
        }
        if (components != null) {
            if (type.equals(TUPLE)) {
                return components;
            }
            if (type.startsWith(TUPLE)) {
                return TypeFactory.build(components.canonicalType + type.substring(TUPLE.length()), null, components, flags);
            }
            throw new IllegalArgumentException("unexpected field components at tuple index " + i);
        }
        if (type.startsWith(TUPLE)) {
            throw new IllegalArgumentException("components missing at tuple index " + i);
        }
        return TypeFactory.create(flags, type);
    }

    static JsonReader reader(InputStream input) {
        return ABIJSON.strict(new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT))));
    }

    static JsonReader reader(String json) {
        return ABIJSON.strict(new StringReader(json));
    }

    private static JsonReader strict(Reader r) {
        JsonReader reader = new JsonReader(r);
        switch (STRICTNESS) {
            case 2: {
                reader.setNestingLimit(50);
            }
            case 1: {
                reader.setStrictness(Strictness.STRICT);
                return reader;
            }
        }
        reader.setLenient(false);
        return reader;
    }

    static {
        JsonReader reader = new JsonReader((Reader)new StringReader(""));
        int level = 0;
        try {
            reader.setStrictness(Strictness.STRICT);
            level = 1;
            reader.setNestingLimit(50);
            level = 2;
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        STRICTNESS = level;
    }

    private static final class NonSyncWriter
    extends CharArrayWriter {
        NonSyncWriter(int initialLen) {
            super(initialLen);
        }

        @Override
        public void write(int c) {
            if (this.count >= this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.buf.length << 1);
            }
            this.buf[this.count++] = (char)c;
        }

        @Override
        public void write(String str, int off, int len) {
            int i = this.count;
            int newCount = i + len;
            char[] buf = this.buf;
            if (newCount > buf.length) {
                this.buf = buf = Arrays.copyOf(buf, Math.max(newCount, buf.length << 1));
            }
            while (i < newCount) {
                buf[i++] = str.charAt(off++);
            }
            this.count = newCount;
        }

        @Override
        public String toString() {
            return new String(this.buf, 0, this.count);
        }
    }
}

