/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.AddressType;
import com.esaulpaugh.headlong.abi.UnitType;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class BigIntegerType
extends UnitType<BigInteger> {
    private static void init() {
        if (AddressType.INSTANCE == null) {
            UnitType.initInstances();
        }
    }

    BigIntegerType(String canonicalType, int bitLength, boolean unsigned) {
        super(canonicalType, BigInteger.class, bitLength, unsigned);
    }

    @Override
    Class<?> arrayClass() {
        return BigInteger[].class;
    }

    @Override
    public int typeCode() {
        return 4;
    }

    @Override
    int validateInternal(BigInteger value) {
        return this.validateBigInt(value);
    }

    @Override
    void encodeTail(BigInteger value, ByteBuffer dest) {
        BigIntegerType.insertInt(value, 32, dest);
    }

    @Override
    void encodePackedUnchecked(BigInteger value, ByteBuffer dest) {
        BigIntegerType.insertInt(value, this.byteLengthPacked(null), dest);
    }

    @Override
    BigInteger decode(ByteBuffer bb, byte[] unitBuffer) {
        return this.decodeValid(bb, unitBuffer);
    }

    static {
        BigIntegerType.init();
    }
}

