/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.rlp;

import com.esaulpaugh.headlong.rlp.DataType;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.rlp.RLPSequenceIterator;
import com.esaulpaugh.headlong.rlp.RLPString;
import com.esaulpaugh.headlong.rlp.ShortInputException;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RLPDecoder {
    public static final RLPDecoder RLP_STRICT = new RLPDecoder(false);
    public static final RLPDecoder RLP_LENIENT = new RLPDecoder(true);
    public final boolean lenient;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    static final byte[] RLP_ZERO_BYTE = new byte[1];

    private RLPDecoder(boolean lenient) {
        this.lenient = lenient;
    }

    public Iterator<RLPItem> sequenceIterator(byte[] buffer) {
        return this.sequenceIterator(buffer, 0);
    }

    public Iterator<RLPItem> sequenceIterator(byte[] buffer, int index) {
        return new RLPSequenceIterator(this, buffer, index);
    }

    public Iterator<RLPItem> sequenceIterator(final InputStream is) {
        return new RLPSequenceIterator(this, Strings.EMPTY_BYTE_ARRAY, 0){

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    int available = is.available();
                    if (available > 0) {
                        int read;
                        int keptBytes = this.buffer.length - this.index;
                        byte[] newBuffer = new byte[keptBytes + available];
                        System.arraycopy(this.buffer, this.index, newBuffer, 0, keptBytes);
                        this.buffer = newBuffer;
                        this.index = 0;
                        int totalRead = 0;
                        do {
                            if ((read = is.read(newBuffer, keptBytes + totalRead, available - totalRead)) > 0) continue;
                            this.buffer = Arrays.copyOf(newBuffer, keptBytes + totalRead);
                            break;
                        } while ((totalRead += read) < available);
                    } else if (this.index >= this.buffer.length) {
                        return false;
                    }
                    this.next = this.decoder.wrap(this.buffer, this.index);
                    return true;
                }
                catch (ShortInputException e) {
                    return false;
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
            }
        };
    }

    public Iterator<RLPItem> sequenceIterator(ReadableByteChannel channel) {
        return this.sequenceIterator(channel, Strings.EMPTY_BYTE_ARRAY, 65536, 640000L);
    }

    public Iterator<RLPItem> sequenceIterator(final ReadableByteChannel channel, byte[] initialBuffer, final int maxBufferResize, final long maxDelayNanos) {
        return new RLPSequenceIterator(this, initialBuffer == null ? new byte[8192] : initialBuffer, 0){
            private static final long INITIAL_DELAY_NANOS = 5000L;
            private ByteBuffer bb;
            private long delayNanos;
            private boolean channelClosed;
            {
                super(decoder, buffer, index);
                this.bb = ByteBuffer.wrap(this.buffer);
                this.delayNanos = 5000L;
                this.channelClosed = false;
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                try {
                    while (true) {
                        int bytesRead;
                        block10: {
                            int capacity;
                            if (this.index == (capacity = this.bb.capacity())) {
                                this.resize(this.calculateResize(0L, capacity < 8192 || capacity > 65536 ? 8192 : capacity), 0);
                            }
                            bytesRead = this.channelClosed || !this.bb.hasRemaining() ? Integer.MAX_VALUE : channel.read(this.bb);
                            int end = this.bb.position();
                            if (this.index < end) {
                                try {
                                    this.next = this.decoder.wrap(this.buffer, this.index, end);
                                    this.delayNanos = 5000L;
                                    return true;
                                }
                                catch (ShortInputException sie) {
                                    if (this.channelClosed || bytesRead <= 0) break block10;
                                    this.delayNanos = 5000L;
                                    if (bytesRead != Integer.MAX_VALUE) continue;
                                    this.resize(this.calculateResize(sie.encodingLen, 8192), this.bb.position() - this.index);
                                    continue;
                                }
                            }
                        }
                        if (!this.channelClosed && bytesRead != -1 && this.delayNanos <= maxDelayNanos) {
                            this.delayNanos = Math.min(this.delayNanos * 2L, maxDelayNanos + 1L);
                            LockSupport.parkNanos(this.delayNanos);
                            continue;
                        }
                        break;
                    }
                }
                catch (ClosedChannelException ignored) {
                    this.channelClosed = true;
                    return this.hasNext();
                }
                catch (IOException io) {
                    throw new UncheckedIOException(io);
                }
                return false;
            }

            private int calculateResize(long encodingLen, int defaultSize) throws IOException {
                long resize = Math.min(maxBufferResize, defaultSize);
                if (resize < encodingLen && (resize = encodingLen) > (long)maxBufferResize) {
                    throw new IOException("resize would exceed limit: " + resize + " > " + maxBufferResize);
                }
                return (int)resize;
            }

            private void resize(int len, int keptBytes) {
                if (len == this.bb.capacity()) {
                    System.arraycopy(this.buffer, this.index, this.buffer, 0, keptBytes);
                    this.bb.position(keptBytes);
                } else {
                    this.bb = ByteBuffer.allocate(len);
                    this.bb.put(this.buffer, this.index, keptBytes);
                    this.buffer = this.bb.array();
                }
                this.index = 0;
            }
        };
    }

    public static Stream<RLPItem> stream(Iterator<RLPItem> iter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 1296), false);
    }

    public Iterator<RLPItem> listIterator(byte[] buffer) {
        return this.listIterator(buffer, 0);
    }

    public Iterator<RLPItem> listIterator(byte[] buffer, int index) {
        return this.wrapList(buffer, index).iterator(this);
    }

    public <T extends RLPItem> T wrapBits(long bits) {
        return this.wrap(bits == 0L ? RLP_ZERO_BYTE : Integers.toBytes(bits), 0);
    }

    public RLPString wrapString(byte[] buffer) {
        return this.wrapString(buffer, 0);
    }

    public RLPList wrapList(byte[] buffer) {
        return this.wrapList(buffer, 0);
    }

    public RLPItem wrapItem(byte[] buffer) {
        return this.wrapItem(buffer, 0);
    }

    public RLPString wrapString(byte[] buffer, int index) {
        return (RLPString)this.wrap(buffer, index);
    }

    public RLPList wrapList(byte[] buffer, int index) {
        return (RLPList)this.wrap(buffer, index);
    }

    public RLPItem wrapItem(byte[] buffer, int index) {
        return this.wrap(buffer, index);
    }

    public <T extends RLPItem> T wrap(byte[] buffer) {
        return this.wrap(buffer, 0);
    }

    public <T extends RLPItem> T wrap(byte[] buffer, int index) {
        return this.wrap(buffer, index, buffer.length);
    }

    <T extends RLPItem> T wrap(byte[] buffer, int index, int containerEnd) {
        byte lead = buffer[index];
        DataType type = DataType.type(lead);
        switch (type.ordinal()) {
            case 0: {
                return (T)RLPDecoder.newSingleByte(buffer, index, containerEnd);
            }
            case 1: {
                return (T)RLPDecoder.newStringShort(buffer, index, lead, containerEnd, this.lenient);
            }
            case 3: {
                return (T)RLPDecoder.newListShort(buffer, index, lead, containerEnd);
            }
            case 2: 
            case 4: {
                return RLPDecoder.newLongItem(lead, type.offset, type.isString, buffer, index, containerEnd, this.lenient);
            }
        }
        throw new AssertionError();
    }

    private static RLPString newSingleByte(byte[] buffer, int index, int containerEnd) {
        return new RLPString(buffer, index, index, 1, RLPDecoder.requireInBounds((long)index + 1L, containerEnd, index, 0L));
    }

    private static RLPString newStringShort(byte[] buffer, int index, byte lead, int containerEnd, boolean lenient) {
        int dataLength = lead - -128;
        long dataIndexLong = (long)index + 1L;
        int endIndex = RLPDecoder.requireInBounds(dataIndexLong + (long)dataLength, containerEnd, index, 0L);
        if (!lenient && dataLength == 1 && DataType.isSingleByte(buffer[(int)dataIndexLong])) {
            throw new IllegalArgumentException("invalid rlp for single byte @ " + index);
        }
        return new RLPString(buffer, index, (int)dataIndexLong, dataLength, endIndex);
    }

    private static RLPList newListShort(byte[] buffer, int index, byte lead, int containerEnd) {
        int dataLength = lead - -64;
        long dataIndex = (long)index + 1L;
        return new RLPList(buffer, index, (int)dataIndex, dataLength, RLPDecoder.requireInBounds(dataIndex + (long)dataLength, containerEnd, index, 0L));
    }

    private static <T extends RLPItem> T newLongItem(byte lead, byte offset, boolean isString, byte[] buffer, int index, int containerEnd, boolean lenient) {
        int lengthOfLength = lead - offset;
        long dataIndexLong = (long)index + 1L + (long)lengthOfLength;
        RLPDecoder.requireInBounds(dataIndexLong, containerEnd, index, dataIndexLong + 56L);
        long dataLengthLong = Integers.getLong(buffer, index + 1, lengthOfLength, lenient);
        if (dataLengthLong < 56L) {
            throw new IllegalArgumentException("long element data length must be 56 or greater; found: " + dataLengthLong + " for element @ " + index);
        }
        if (dataLengthLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("length is too great: " + dataLengthLong);
        }
        int endIndex = RLPDecoder.requireInBounds(dataIndexLong + dataLengthLong, containerEnd, index, dataIndexLong + dataLengthLong - (long)index);
        return (T)(isString ? new RLPString(buffer, index, (int)dataIndexLong, (int)dataLengthLong, endIndex) : new RLPList(buffer, index, (int)dataIndexLong, (int)dataLengthLong, endIndex));
    }

    private static int requireInBounds(long val, int containerEnd, int index, long encodingLen) {
        if (val > (long)containerEnd) {
            throw new ShortInputException("element @ index " + index + " exceeds its container: " + val + " > " + containerEnd, encodingLen != 0L ? encodingLen : val);
        }
        return (int)val;
    }
}

