/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.hapi.utils.EthSigsUtils;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HexFormat;
import java.util.Objects;

public final class AliasUtils {
    private static final byte[] ENTITY_NUM_ALIAS_PREFIX = new byte[12];
    private static final int EVM_ADDRESS_SIZE = 20;
    private static final Bytes ECDSA_KEY_ALIAS_PREFIX = Bytes.wrap((byte[])HexFormat.of().parseHex("3a21"));
    private static final int ECDSA_SECP256K1_ALIAS_SIZE = 33;
    private static final int ED25519_ALIAS_SIZE = 32;

    private AliasUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static boolean isOfEvmAddressSize(@NonNull Bytes alias) {
        return alias.length() == 20L;
    }

    @Nullable
    public static Bytes extractEvmAddress(@NonNull Bytes alias) {
        Objects.requireNonNull(alias);
        if (AliasUtils.isOfEvmAddressSize(alias)) {
            return alias;
        }
        Key key = AliasUtils.asKeyFromAliasOrElse(alias, null);
        return key != null && key.hasEcdsaSecp256k1() ? AliasUtils.recoverAddressFromPubKey(key.ecdsaSecp256k1OrThrow()) : null;
    }

    @Nullable
    public static Bytes extractEvmAddress(@Nullable Key key) {
        return key != null && key.hasEcdsaSecp256k1() ? AliasUtils.recoverAddressFromPubKey(key.ecdsaSecp256k1OrThrow()) : null;
    }

    public static boolean isEntityNumAlias(Bytes alias) {
        return AliasUtils.isOfEvmAddressSize(alias) && alias.matchesPrefix(ENTITY_NUM_ALIAS_PREFIX);
    }

    public static boolean isKeyAlias(@NonNull Bytes alias) {
        Key key = AliasUtils.asKeyFromAliasOrElse(alias, null);
        if (key == null) {
            return false;
        }
        if (!KeyUtils.isValid((Key)key)) {
            return false;
        }
        if (key.hasEcdsaSecp256k1()) {
            Bytes ecdsa = key.ecdsaSecp256k1OrThrow();
            return ecdsa.length() == 33L && alias.matchesPrefix((RandomAccessData)ECDSA_KEY_ALIAS_PREFIX);
        }
        if (key.hasEd25519()) {
            return key.ed25519OrThrow().length() == 32L;
        }
        return false;
    }

    @NonNull
    public static Bytes recoverAddressFromPubKey(@NonNull Bytes alias) {
        return EthSigsUtils.recoverAddressFromPubKey((Bytes)alias);
    }

    public static boolean isSerializedProtoKey(@NonNull Bytes alias) {
        Objects.requireNonNull(alias);
        if (!AliasUtils.isAliasSizeGreaterThanEvmAddress(alias)) {
            return false;
        }
        try {
            Key key = (Key)Key.PROTOBUF.parseStrict(alias.toReadableSequentialData());
            return key.hasEcdsaSecp256k1() || key.hasEd25519();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Long extractIdFromAddressAlias(Bytes addressAlias) {
        return addressAlias.getLong(12L);
    }

    public static boolean isAlias(@NonNull AccountID idOrAlias) {
        Objects.requireNonNull(idOrAlias);
        return !idOrAlias.hasAccountNum() && idOrAlias.hasAlias();
    }

    @NonNull
    public static Key asKeyFromAlias(@NonNull Bytes alias) {
        Objects.requireNonNull(alias);
        Key key = AliasUtils.asKeyFromAliasOrElse(alias, null);
        if (key == null) {
            throw new HandleException(ResponseCodeEnum.INVALID_ALIAS_KEY);
        }
        return key;
    }

    @NonNull
    public static Key asKeyFromAliasPreCheck(@NonNull Bytes alias) throws PreCheckException {
        Objects.requireNonNull(alias);
        Key key = AliasUtils.asKeyFromAliasOrElse(alias, null);
        if (key == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ALIAS_KEY);
        }
        return key;
    }

    @Nullable
    public static Key asKeyFromAliasOrElse(@NonNull Bytes alias, @Nullable Key def) {
        Objects.requireNonNull(alias);
        if (!AliasUtils.isAliasSizeGreaterThanEvmAddress(alias)) {
            return def;
        }
        try {
            return (Key)Key.PROTOBUF.parseStrict(alias.toReadableSequentialData());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean isAliasSizeGreaterThanEvmAddress(@NonNull Bytes alias) {
        Objects.requireNonNull(alias);
        return alias.length() > 20L;
    }
}

