/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.api;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenFreezeStatus;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKycStatus;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.api.StakingRewardsApi;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface AccountSummariesApi {
    public static final int EVM_ADDRESS_SIZE = 20;
    public static final long SENTINEL_NODE_ID = -1L;
    public static final AccountID SENTINEL_ACCOUNT_ID = AccountID.newBuilder().accountNum(0L).build();

    public static String hexedEvmAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        AccountID accountId = account.accountIdOrThrow();
        Bytes arbitraryEvmAddress = AliasUtils.extractEvmAddress(account.alias());
        byte[] evmAddress = arbitraryEvmAddress != null ? arbitraryEvmAddress.toByteArray() : CommonUtils.asEvmAddress((long)accountId.accountNumOrThrow());
        return org.hiero.base.utility.CommonUtils.hex((byte[])evmAddress);
    }

    public static List<TokenRelationship> tokenRelationshipsOf(@NonNull Account account, @NonNull ReadableTokenStore readableTokenStore, @NonNull ReadableTokenRelationStore tokenRelationStore, long limit) {
        AccountID accountID;
        TokenRelation tokenRelation;
        Objects.requireNonNull(account);
        Objects.requireNonNull(tokenRelationStore);
        Objects.requireNonNull(readableTokenStore);
        ArrayList<TokenRelationship> ret = new ArrayList<TokenRelationship>();
        TokenID tokenId = account.headTokenId();
        int count = 0;
        while (tokenId != null && !tokenId.equals((Object)TokenID.DEFAULT) && (long)count < limit && (tokenRelation = tokenRelationStore.get(accountID = account.accountId(), tokenId)) != null) {
            Token token = readableTokenStore.get(tokenId);
            if (token != null) {
                AccountSummariesApi.addTokenRelation(ret, token, tokenRelation, tokenId);
            }
            tokenId = tokenRelation.nextToken();
            ++count;
        }
        return ret;
    }

    private static void addTokenRelation(List<TokenRelationship> ret, Token token, TokenRelation tokenRelation, TokenID tokenId) {
        TokenFreezeStatus freezeStatus = TokenFreezeStatus.FREEZE_NOT_APPLICABLE;
        if (token.hasFreezeKey()) {
            freezeStatus = tokenRelation.frozen() ? TokenFreezeStatus.FROZEN : TokenFreezeStatus.UNFROZEN;
        }
        TokenKycStatus kycStatus = TokenKycStatus.KYC_NOT_APPLICABLE;
        if (token.hasKycKey()) {
            kycStatus = tokenRelation.kycGranted() ? TokenKycStatus.GRANTED : TokenKycStatus.REVOKED;
        }
        TokenRelationship tokenRelationship = TokenRelationship.newBuilder().tokenId(tokenId).symbol(token.symbol()).balance(tokenRelation.balance()).decimals(token.decimals()).kycStatus(kycStatus).freezeStatus(freezeStatus).automaticAssociation(tokenRelation.automaticAssociation()).build();
        ret.add(tokenRelationship);
    }

    public static StakingInfo summarizeStakingInfo(int numStoredPeriods, long stakePeriodMins, boolean areRewardsActive, @NonNull Account account, @NonNull ReadableStakingInfoStore stakingInfoStore, @NonNull Instant estimatedConsensusNow) {
        Objects.requireNonNull(account);
        Objects.requireNonNull(stakingInfoStore);
        Objects.requireNonNull(estimatedConsensusNow);
        StakingInfo.Builder stakingInfo = StakingInfo.newBuilder().declineReward(account.declineReward()).stakedToMe(account.stakedToMe());
        if (account.hasStakedNodeId() && account.stakedNodeIdOrThrow() != -1L) {
            stakingInfo.stakedNodeId(account.stakedNodeIdOrThrow().longValue());
            AccountSummariesApi.addNodeStakeMeta(numStoredPeriods, stakePeriodMins, areRewardsActive, account, stakingInfoStore, stakingInfo, estimatedConsensusNow);
        } else if (account.hasStakedAccountId() && account.stakedAccountId() != null) {
            stakingInfo.stakedAccountId(account.stakedAccountIdOrThrow());
        }
        return stakingInfo.build();
    }

    public static void addNodeStakeMeta(int numStoredPeriods, long stakePeriodMins, boolean areRewardsActive, @NonNull Account account, @NonNull ReadableStakingInfoStore readableStakingInfoStore, @NonNull StakingInfo.Builder stakingInfo, @NonNull Instant estimatedConsensusNow) {
        stakingInfo.stakePeriodStart(Timestamp.newBuilder().seconds(StakingRewardsApi.epochSecondAtStartOfPeriod(account.stakePeriodStart(), stakePeriodMins))).pendingReward(StakingRewardsApi.estimatePendingReward(numStoredPeriods, stakePeriodMins, areRewardsActive, account, readableStakingInfoStore, estimatedConsensusNow));
    }
}

